/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.shared.common.error.StandardException;

public class JDBCBoot {
    private Properties bootProperties = new Properties();
    private static final String NETWORK_SERVER_AUTOSTART_CLASS_NAME = "org.apache.derby.iapi.jdbc.DRDAServerStarter";

    void addProperty(String string, String string2) {
        this.bootProperties.put(string, string2);
    }

    public static void boot() {
        block3: {
            PrintWriter printWriter = DriverManager.getLogWriter();
            if (printWriter == null) {
                printWriter = new PrintWriter(System.err, true);
            }
            try {
                new JDBCBoot().boot("jdbc:derby:", printWriter);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(printWriter);
                if (!(throwable instanceof RuntimeException)) break block3;
                throw (RuntimeException)throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(String string, PrintWriter printWriter) {
        String string2 = NETWORK_SERVER_AUTOSTART_CLASS_NAME;
        synchronized (NETWORK_SERVER_AUTOSTART_CLASS_NAME) {
            if (InternalDriver.activeDriver() == null) {
                this.addProperty("derby.service.jdbc", InternalDriver.class.getName());
                this.addProperty("derby.service.authentication", "org.apache.derby.iapi.jdbc.AuthenticationService");
                JDBCBoot.boot(this.bootProperties, printWriter);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static void boot(final Properties properties, final PrintWriter printWriter) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Monitor.startMonitor(properties, printWriter);
                if (Boolean.valueOf(PropertyUtil.getSystemProperty("derby.drda.startNetworkServer")).booleanValue()) {
                    try {
                        Monitor.startSystemModule(JDBCBoot.NETWORK_SERVER_AUTOSTART_CLASS_NAME);
                    }
                    catch (StandardException standardException) {
                        Monitor.logTextMessage("J102", standardException.getMessage());
                    }
                }
                return null;
            }
        });
    }
}

