/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.feature.Features;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.dao.user.GroupUserDao;
import org.apache.openmeetings.db.dto.basic.SearchResult;
import org.apache.openmeetings.db.dto.basic.ServiceResult;
import org.apache.openmeetings.db.dto.user.GroupDTO;
import org.apache.openmeetings.db.dto.user.UserSearchResult;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.webservice.BaseWebService;
import org.apache.openmeetings.webservice.error.ServiceException;
import org.apache.openmeetings.webservice.schema.GroupDTOListWrapper;
import org.apache.openmeetings.webservice.schema.ServiceResultWrapper;
import org.apache.openmeetings.webservice.schema.UserSearchResultWrapper;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="groupWebService")
@WebService(serviceName="org.apache.openmeetings.webservice.GroupWebService", targetNamespace="http://webservice.openmeetings.apache.org/")
@Features(features={"org.apache.cxf.ext.logging.LoggingFeature"})
@Produces(value={"application/json"})
@Tag(name="GroupService")
@Path(value="/group")
public class GroupWebService
extends BaseWebService {
    private static final Logger log = LoggerFactory.getLogger(GroupWebService.class);
    @Inject
    private GroupDao groupDao;
    @Inject
    private GroupUserDao groupUserDao;

    @POST
    @Path(value="/")
    @Operation(description="add a new group", responses={@ApiResponse(responseCode="200", description="ServiceResult with result type, and id of the group added", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult add(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="The name of the group") @QueryParam(value="name") @WebParam(name="name") String name) throws ServiceException {
        log.debug("add:: name {}", (Object)name);
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            Group o = new Group();
            o.setName(name);
            return new ServiceResult(String.valueOf(this.groupDao.update(o, sd.getUserId()).getId()), ServiceResult.Type.SUCCESS);
        });
    }

    @GET
    @Path(value="/")
    @Operation(description="Get the list of all groups", responses={@ApiResponse(responseCode="200", description="list of users", content={@Content(schema=@Schema(implementation=GroupDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<GroupDTO> get(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> GroupDTO.list((List)this.groupDao.get(0L, Integer.MAX_VALUE)));
    }

    @POST
    @Path(value="/{id}/users/{userid}")
    @Operation(description="Add USER to a certain group", responses={@ApiResponse(responseCode="200", description="ServiceResult with result type, and id of the USER added, or error id in case of the error as text", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult addUser(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="the USER id") @PathParam(value="id") @WebParam(name="id") Long id, @Parameter(required=true, description="the group id") @PathParam(value="userid") @WebParam(name="userid") Long userid) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            if (!this.groupUserDao.isUserInGroup(id.longValue(), userid.longValue())) {
                User u = this.userDao.get(userid);
                u.addGroup(this.groupDao.get(id));
                this.userDao.update(u, sd.getUserId());
            }
            return new ServiceResult(String.valueOf(userid), ServiceResult.Type.SUCCESS);
        });
    }

    @DELETE
    @Path(value="/{id}/users/{userid}")
    @Operation(description="Remove USER from a certain group", responses={@ApiResponse(responseCode="200", description="ServiceResult with result type, and id of the USER removed, or error id in case of the error as text", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult removeUser(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="the USER id") @PathParam(value="id") @WebParam(name="id") Long id, @Parameter(required=true, description="the group id") @PathParam(value="userid") @WebParam(name="userid") Long userid) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            if (this.groupUserDao.isUserInGroup(id.longValue(), userid.longValue())) {
                User u = this.userDao.get(userid);
                Iterator iter = u.getGroupUsers().iterator();
                while (iter.hasNext()) {
                    GroupUser gu = (GroupUser)iter.next();
                    if (!id.equals(gu.getGroup().getId())) continue;
                    iter.remove();
                }
                this.userDao.update(u, sd.getUserId());
            }
            return new ServiceResult(String.valueOf(userid), ServiceResult.Type.SUCCESS);
        });
    }

    @POST
    @Path(value="/{id}/rooms/add/{roomid}")
    @Operation(description="Adds a room to an group", responses={@ApiResponse(responseCode="200", description="ServiceResult with result type", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult addRoom(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="Id of group that the room is being paired with") @PathParam(value="id") @WebParam(name="id") Long id, @Parameter(required=true, description="Id of room to be added") @PathParam(value="roomid") @WebParam(name="roomid") Long roomid) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            Room r = this.roomDao.get(roomid);
            if (r != null) {
                if (r.getGroups() == null) {
                    r.setGroups(new ArrayList());
                }
                boolean found = false;
                for (RoomGroup ro : r.getGroups()) {
                    if (!ro.getGroup().getId().equals(id)) continue;
                    found = true;
                }
                if (!found) {
                    r.addGroup(this.groupDao.get(id));
                    this.roomDao.update(r, sd.getUserId());
                    return new ServiceResult("Success", ServiceResult.Type.SUCCESS);
                }
            }
            return new ServiceResult("Not added", ServiceResult.Type.ERROR);
        });
    }

    @GET
    @Path(value="/users/{id}")
    @Operation(description="Search users and return them", responses={@ApiResponse(responseCode="200", description="users found", content={@Content(schema=@Schema(implementation=UserSearchResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public UserSearchResult getUsers(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="the group id") @PathParam(value="id") @WebParam(name="id") long id, @Parameter(required=true, description="first record") @QueryParam(value="start") @WebParam(name="start") int start, @Parameter(required=true, description="max records") @QueryParam(value="max") @WebParam(name="max") int max, @Parameter(required=true, description="orderby clause") @QueryParam(value="orderby") @WebParam(name="orderby") String orderby, @Parameter(required=true, description="asc or desc") @QueryParam(value="asc") @WebParam(name="asc") boolean asc) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            SearchResult result = new SearchResult();
            result.setObjectName(User.class.getName());
            result.setRecords(Long.valueOf(this.groupUserDao.count(id)));
            result.setResult(new ArrayList());
            String order = StringUtils.isAlphanumeric((CharSequence)orderby) ? orderby : "id";
            for (GroupUser ou : this.groupUserDao.get(id, null, (long)start, (long)max, order == null ? null : new SortParam((Object)order, asc))) {
                result.getResult().add(ou.getUser());
            }
            return new UserSearchResult(result);
        });
    }

    @WebMethod
    @DELETE
    @Path(value="/{id}")
    @Operation(description="Deletes a group", responses={@ApiResponse(responseCode="200", description="ServiceResult with result type", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult delete(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the id of the group") @WebParam(name="id") @PathParam(value="id") long id) throws ServiceException {
        return this.performCall(sid, User.Right.ADMIN, (Sessiondata sd) -> {
            this.groupDao.delete((Group)this.groupDao.get(id), sd.getUserId());
            return new ServiceResult("Deleted", ServiceResult.Type.SUCCESS);
        });
    }
}

