/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.impl.config.DelegatingInstanceConfig;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class JetConfig {
    public static final int DEFAULT_FLOW_CONTROL_PERIOD_MS = 100;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    private static final long SCALE_UP_DELAY_MILLIS_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    private static final long MAX_PROCESSOR_ACCUMULATED_RECORDS = Long.MAX_VALUE;
    private final DelegatingInstanceConfig instanceConfig = new DelegatingInstanceConfig(this);
    private EdgeConfig defaultEdgeConfig = new EdgeConfig();
    private boolean enabled;
    private boolean resourceUploadEnabled;
    private int cooperativeThreadCount = RuntimeAvailableProcessors.get();
    private int flowControlPeriodMs = 100;
    private int backupCount = 1;
    private long scaleUpDelayMillis = SCALE_UP_DELAY_MILLIS_DEFAULT;
    private boolean losslessRestartEnabled;
    private long maxProcessorAccumulatedRecords = Long.MAX_VALUE;

    @Nonnull
    public JetConfig setCooperativeThreadCount(int size) {
        Preconditions.checkPositive(size, "cooperativeThreadCount should be a positive number");
        this.cooperativeThreadCount = size;
        return this;
    }

    public int getCooperativeThreadCount() {
        return this.cooperativeThreadCount;
    }

    @Nonnull
    public JetConfig setFlowControlPeriodMs(int flowControlPeriodMs) {
        Preconditions.checkPositive(flowControlPeriodMs, "flowControlPeriodMs should be a positive number");
        this.flowControlPeriodMs = flowControlPeriodMs;
        return this;
    }

    public int getFlowControlPeriodMs() {
        return this.flowControlPeriodMs;
    }

    @Nonnull
    public JetConfig setBackupCount(int newBackupCount) {
        Preconditions.checkBackupCount(newBackupCount, 0);
        this.backupCount = newBackupCount;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public JetConfig setScaleUpDelayMillis(long millis) {
        Preconditions.checkNotNegative(millis, "The delay must be >=0");
        this.scaleUpDelayMillis = millis;
        return this;
    }

    public long getScaleUpDelayMillis() {
        return this.scaleUpDelayMillis;
    }

    public JetConfig setLosslessRestartEnabled(boolean enabled) {
        this.losslessRestartEnabled = enabled;
        return this;
    }

    public boolean isLosslessRestartEnabled() {
        return this.losslessRestartEnabled;
    }

    public JetConfig setMaxProcessorAccumulatedRecords(long maxProcessorAccumulatedRecords) {
        Preconditions.checkPositive(maxProcessorAccumulatedRecords, "maxProcessorAccumulatedRecords must be a positive number");
        this.maxProcessorAccumulatedRecords = maxProcessorAccumulatedRecords;
        return this;
    }

    public long getMaxProcessorAccumulatedRecords() {
        return this.maxProcessorAccumulatedRecords;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JetConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isResourceUploadEnabled() {
        return this.resourceUploadEnabled;
    }

    public JetConfig setResourceUploadEnabled(boolean resourceUploadEnabled) {
        this.resourceUploadEnabled = resourceUploadEnabled;
        return this;
    }

    @Nonnull
    @Deprecated
    public InstanceConfig getInstanceConfig() {
        return this.instanceConfig;
    }

    @Nonnull
    @Deprecated
    public JetConfig setInstanceConfig(@Nonnull InstanceConfig instanceConfig) {
        Preconditions.checkNotNull(instanceConfig, "instanceConfig");
        this.instanceConfig.set(instanceConfig);
        return this;
    }

    @Nonnull
    public EdgeConfig getDefaultEdgeConfig() {
        return this.defaultEdgeConfig;
    }

    @Nonnull
    public JetConfig setDefaultEdgeConfig(@Nonnull EdgeConfig defaultEdgeConfig) {
        Preconditions.checkNotNull(defaultEdgeConfig, "defaultEdgeConfig");
        this.defaultEdgeConfig = defaultEdgeConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JetConfig jetConfig = (JetConfig)o;
        if (this.enabled != jetConfig.enabled) {
            return false;
        }
        if (this.resourceUploadEnabled != jetConfig.resourceUploadEnabled) {
            return false;
        }
        if (!this.instanceConfig.equals(jetConfig.instanceConfig)) {
            return false;
        }
        return this.defaultEdgeConfig.equals(jetConfig.defaultEdgeConfig);
    }

    public int hashCode() {
        int result = this.instanceConfig.hashCode();
        result = 31 * result + this.defaultEdgeConfig.hashCode();
        result = 31 * result + (this.enabled ? 1 : 0);
        result = 31 * result + (this.resourceUploadEnabled ? 1 : 0);
        return result;
    }

    public String toString() {
        return "JetConfig{defaultEdgeConfig=" + this.defaultEdgeConfig + ", enabled=" + this.enabled + ", resourceUploadEnabled=" + this.resourceUploadEnabled + ", cooperativeThreadCount=" + this.cooperativeThreadCount + ", flowControlPeriodMs=" + this.flowControlPeriodMs + ", backupCount=" + this.backupCount + ", scaleUpDelayMillis=" + this.scaleUpDelayMillis + ", losslessRestartEnabled=" + this.losslessRestartEnabled + ", maxProcessorAccumulatedRecords=" + this.maxProcessorAccumulatedRecords + "}";
    }
}

