/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl;

import com.hazelcast.shaded.com.fasterxml.jackson.core.TreeNode;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.JSON;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.Types;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.UUID;

public abstract class ValueLocatorBase {
    public static final int SER_UNKNOWN = 0;
    public static final int SER_MAP = 1;
    public static final int SER_LIST = 2;
    public static final int SER_COLLECTION = 3;
    public static final int SER_OBJECT_ARRAY = 4;
    public static final int SER_INT_ARRAY = 5;
    public static final int SER_LONG_ARRAY = 6;
    public static final int SER_BOOLEAN_ARRAY = 7;
    public static final int SER_TREE_NODE = 8;
    public static final int SER_STRING = 9;
    public static final int SER_CHARACTER_SEQUENCE = 10;
    public static final int SER_CHAR_ARRAY = 11;
    public static final int SER_BYTE_ARRAY = 12;
    public static final int SER_NUMBER_BYTE = 13;
    public static final int SER_NUMBER_SHORT = 14;
    public static final int SER_NUMBER_INTEGER = 15;
    public static final int SER_NUMBER_INTEGER_WRAPPER = 16;
    public static final int SER_NUMBER_LONG = 17;
    public static final int SER_NUMBER_LONG_WRAPPER = 18;
    public static final int SER_NUMBER_FLOAT = 19;
    public static final int SER_NUMBER_FLOAT_WRAPPER = 20;
    public static final int SER_NUMBER_DOUBLE = 21;
    public static final int SER_NUMBER_DOUBLE_WRAPPER = 22;
    public static final int SER_NUMBER_BIG_INTEGER = 23;
    public static final int SER_NUMBER_BIG_DECIMAL = 24;
    public static final int SER_BOOLEAN = 25;
    public static final int SER_BOOLEAN_WRAPPER = 26;
    public static final int SER_CHAR = 27;
    public static final int SER_ENUM = 28;
    public static final int SER_DATE = 29;
    public static final int SER_CALENDAR = 30;
    public static final int SER_CLASS = 31;
    public static final int SER_FILE = 32;
    public static final int SER_UUID = 33;
    public static final int SER_URL = 34;
    public static final int SER_URI = 35;
    public static final int SER_PATH = 36;
    public static final int SER_ITERABLE = 37;
    protected static final int CACHE_FLAGS = JSON.CACHE_FLAGS;

    protected int _findSimpleType(Class<?> clazz, boolean bl) {
        if (clazz == String.class) {
            return 9;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                if (clazz == byte[].class) {
                    return 12;
                }
                if (clazz == char[].class) {
                    return 11;
                }
                if (clazz == int[].class) {
                    return 5;
                }
                if (clazz == long[].class) {
                    return 6;
                }
                if (clazz == boolean[].class) {
                    return 7;
                }
                return 0;
            }
            return 4;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return 25;
            }
            if (clazz == Integer.TYPE) {
                return 15;
            }
            if (clazz == Long.TYPE) {
                return 17;
            }
            if (clazz == Byte.TYPE) {
                return 13;
            }
            if (clazz == Short.TYPE) {
                return 14;
            }
            if (clazz == Double.TYPE) {
                return 21;
            }
            if (clazz == Float.TYPE) {
                return 19;
            }
            if (clazz == Character.TYPE) {
                return 27;
            }
            throw new IllegalArgumentException("Unrecognized primitive type: " + clazz.getName());
        }
        if (clazz == Boolean.class) {
            return 26;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (clazz == Integer.class) {
                return 16;
            }
            if (clazz == Long.class) {
                return 18;
            }
            if (clazz == Double.class) {
                return 22;
            }
            if (clazz == Float.class) {
                return 20;
            }
            if (clazz == BigDecimal.class) {
                return 24;
            }
            if (clazz == BigInteger.class) {
                return 23;
            }
            if (clazz == Byte.class) {
                return 13;
            }
            if (clazz == Short.class) {
                return 14;
            }
            return 0;
        }
        if (clazz == Character.class) {
            return 27;
        }
        if (Types.isEnum(clazz)) {
            return 28;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (List.class.isAssignableFrom(clazz) && RandomAccess.class.isAssignableFrom(clazz)) {
                return 2;
            }
            return 3;
        }
        if (TreeNode.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return 30;
        }
        if (clazz == Class.class) {
            return 31;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 29;
        }
        if (File.class.isAssignableFrom(clazz)) {
            return 32;
        }
        if (URL.class.isAssignableFrom(clazz)) {
            return 34;
        }
        if (URI.class.isAssignableFrom(clazz)) {
            return 35;
        }
        if (UUID.class.isAssignableFrom(clazz)) {
            return 33;
        }
        if (Path.class.isAssignableFrom(clazz)) {
            return 36;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return 10;
        }
        if (bl && Iterable.class.isAssignableFrom(clazz) && !Path.class.isAssignableFrom(clazz)) {
            return 37;
        }
        return 0;
    }
}

