/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.mediaserver;

import com.github.openjson.JSONObject;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.mediaserver.AbstractStream;
import org.apache.openmeetings.mediaserver.KTestStream;
import org.apache.openmeetings.mediaserver.KurentoHandler;
import org.kurento.client.IceCandidate;

@Singleton
@Named
class TestStreamProcessor {
    private final Map<String, KTestStream> streamByUid = new ConcurrentHashMap<String, KTestStream>();
    @Inject
    private KurentoHandler kHandler;

    TestStreamProcessor() {
    }

    void onMessage(IWsClient c, String cmdId, JSONObject msg) {
        KTestStream user = this.getByUid(c.getUid());
        switch (cmdId) {
            case "wannaRecord": {
                WebSocketHelper.sendClient((IWsClient)c, (JSONObject)TestStreamProcessor.newTestKurentoMsg().put("id", (Object)"canRecord").put("iceServers", (Object)this.kHandler.getTurnServers(null, true)));
                break;
            }
            case "record": {
                if (user != null) {
                    user.release();
                }
                user = new KTestStream(c, msg);
                this.streamByUid.put(c.getUid(), user);
                break;
            }
            case "iceCandidate": {
                JSONObject candidate = msg.getJSONObject("candidate");
                if (user == null) break;
                IceCandidate cand = new IceCandidate(candidate.getString("candidate"), candidate.getString("sdpMid"), candidate.getInt("sdpMLineIndex"));
                user.addCandidate(cand);
                break;
            }
            case "wannaPlay": {
                WebSocketHelper.sendClient((IWsClient)c, (JSONObject)TestStreamProcessor.newTestKurentoMsg().put("id", (Object)"canPlay").put("iceServers", (Object)this.kHandler.getTurnServers(null, true)));
                break;
            }
            case "play": {
                if (user == null) break;
                user.play(c, msg);
                break;
            }
        }
    }

    private KTestStream getByUid(String uid) {
        return uid == null ? null : this.streamByUid.get(uid);
    }

    static JSONObject newTestKurentoMsg() {
        return KurentoHandler.newKurentoMsg().put("mode", (Object)"test");
    }

    void remove(IWsClient c) {
        KTestStream s = this.getByUid(c.getUid());
        if (s != null) {
            s.release();
        }
    }

    public void release(AbstractStream stream) {
        this.streamByUid.remove(stream.getUid());
    }

    public void destroy() {
        for (Map.Entry<String, KTestStream> e : this.streamByUid.entrySet()) {
            e.getValue().release();
            this.streamByUid.remove(e.getKey());
        }
        this.streamByUid.clear();
    }
}

