/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.basic;

import com.github.openjson.JSONObject;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.basic.StreamDesc;

public class WebcamStreamDesc
extends StreamDesc {
    private boolean camEnabled = false;
    private boolean micEnabled = false;

    public WebcamStreamDesc(WebcamStreamDesc sd) {
        super(sd);
        this.camEnabled = sd.camEnabled;
        this.micEnabled = sd.micEnabled;
    }

    public WebcamStreamDesc(Client client, Client.Activity toggle) {
        super(client, Client.StreamType.WEBCAM);
        this.setWidth(client.getWidth());
        this.setHeight(client.getHeight());
        if (client.isAllowed(Client.Activity.AUDIO)) {
            this.activities.add(Client.Activity.AUDIO);
        }
        if (client.isAllowed(Client.Activity.VIDEO)) {
            this.activities.add(Client.Activity.VIDEO);
        }
        if (this.has(Client.Activity.AUDIO) && this.has(Client.Activity.VIDEO)) {
            this.activities.add(Client.Activity.AUDIO_VIDEO);
        }
        switch (toggle) {
            case AUDIO: {
                if (!this.has(toggle)) break;
                this.micEnabled = true;
                break;
            }
            case VIDEO: {
                if (!this.has(toggle)) break;
                this.camEnabled = true;
                break;
            }
            case AUDIO_VIDEO: {
                if (!this.has(toggle)) break;
                this.micEnabled = true;
                this.camEnabled = true;
                break;
            }
        }
    }

    @Override
    public StreamDesc remove(Client.Activity a) {
        super.remove(a);
        switch (a) {
            case AUDIO: {
                this.micEnabled = false;
                break;
            }
            case VIDEO: {
                this.camEnabled = false;
                break;
            }
            case AUDIO_VIDEO: {
                this.micEnabled = false;
                this.camEnabled = false;
                break;
            }
        }
        return this;
    }

    public void toggle(Client.Activity toggle) {
        switch (toggle) {
            case AUDIO: {
                this.micEnabled = !this.micEnabled;
                break;
            }
            case VIDEO: {
                this.camEnabled = !this.camEnabled;
                break;
            }
        }
    }

    public boolean isBroadcasting() {
        return !this.activities.isEmpty() && (this.camEnabled || this.micEnabled);
    }

    @Override
    protected boolean allowed(Client.Activity a) {
        return Client.Activity.AUDIO == a || Client.Activity.VIDEO == a || Client.Activity.AUDIO_VIDEO == a;
    }

    @Override
    public JSONObject toJson(boolean self) {
        return super.toJson(self).put("camEnabled", this.camEnabled).put("micEnabled", this.micEnabled);
    }
}

