/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.entity.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleHelper {
    private static final Logger log = LoggerFactory.getLogger(LocaleHelper.class);

    private LocaleHelper() {
    }

    public static List<String> getCountries() {
        return List.of(Locale.getISOCountries());
    }

    public static String getCountryName(String code, Locale l) {
        return new Locale.Builder().setRegion(code).build().getDisplayCountry(l);
    }

    public static String getCountryName(String code) {
        return new Locale.Builder().setRegion(code).build().getDisplayCountry();
    }

    public static String validateCountry(String inCode) {
        String code;
        List<String> list = LocaleHelper.getCountries();
        HashSet<String> countries = new HashSet<String>(list);
        String string = code = inCode == null ? "" : inCode.toUpperCase(Locale.ROOT);
        if (!countries.contains(code)) {
            String newCountry = list.get(0);
            log.warn("Invalid country found: {}, will be replaced with: {}", (Object)code, (Object)newCountry);
            code = newCountry;
        }
        return code;
    }

    public static Locale getLocale(Long langId) {
        Locale l = langId == 3L ? Locale.GERMANY : LabelDao.getLocale(langId);
        return l == null ? Locale.ENGLISH : l;
    }

    public static Locale getLocale(User u) {
        Locale locale = LocaleHelper.getLocale(u.getLanguageId());
        try {
            Locale.Builder builder = new Locale.Builder().setLanguage(locale.getLanguage());
            if (u.getAddress() != null && u.getAddress().getCountry() != null) {
                builder.setRegion(u.getAddress().getCountry());
            }
            locale = builder.build();
        }
        catch (Exception e) {
            log.error("Unexpected Error while constructing locale for the user", (Throwable)e);
        }
        return locale;
    }
}

