/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.util;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;

public final class ContainingConstraint
implements FSMatchConstraint {
    private static final long serialVersionUID = 8393109549729168545L;
    private final Collection<AnnotationFS> mContainingAnnotations = new LinkedList<AnnotationFS>();

    public ContainingConstraint() {
    }

    public ContainingConstraint(AnnotationFS containingAnnotation) {
        this.mContainingAnnotations.add(containingAnnotation);
    }

    public boolean match(FeatureStructure featureStructure) {
        if (!(featureStructure instanceof AnnotationFS)) {
            return false;
        }
        AnnotationFS annotation = (AnnotationFS)featureStructure;
        for (AnnotationFS containingAnnotation : this.mContainingAnnotations) {
            if (!this.isContaining(annotation, containingAnnotation)) continue;
            return true;
        }
        return false;
    }

    private boolean isContaining(AnnotationFS annotation, AnnotationFS containing) {
        return containing.getBegin() <= annotation.getBegin() && containing.getEnd() >= annotation.getEnd();
    }
}

