/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariablePermission is an enum
type OpcuaNodeIdServicesVariablePermission int32

type IOpcuaNodeIdServicesVariablePermission interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariablePermission_PermissionType_OptionSetValues OpcuaNodeIdServicesVariablePermission = 15030
)

var OpcuaNodeIdServicesVariablePermissionValues []OpcuaNodeIdServicesVariablePermission

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariablePermissionValues = []OpcuaNodeIdServicesVariablePermission{
		OpcuaNodeIdServicesVariablePermission_PermissionType_OptionSetValues,
	}
}

func OpcuaNodeIdServicesVariablePermissionByValue(value int32) (enum OpcuaNodeIdServicesVariablePermission, ok bool) {
	switch value {
	case 15030:
		return OpcuaNodeIdServicesVariablePermission_PermissionType_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePermissionByName(value string) (enum OpcuaNodeIdServicesVariablePermission, ok bool) {
	switch value {
	case "PermissionType_OptionSetValues":
		return OpcuaNodeIdServicesVariablePermission_PermissionType_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePermissionKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariablePermissionValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariablePermission(structType any) OpcuaNodeIdServicesVariablePermission {
	castFunc := func(typ any) OpcuaNodeIdServicesVariablePermission {
		if sOpcuaNodeIdServicesVariablePermission, ok := typ.(OpcuaNodeIdServicesVariablePermission); ok {
			return sOpcuaNodeIdServicesVariablePermission
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariablePermission) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariablePermission) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariablePermissionParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariablePermission, error) {
	return OpcuaNodeIdServicesVariablePermissionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariablePermissionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariablePermission, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariablePermission", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariablePermission")
	}
	if enum, ok := OpcuaNodeIdServicesVariablePermissionByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariablePermission")
		return OpcuaNodeIdServicesVariablePermission(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariablePermission) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariablePermission) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariablePermission", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariablePermission) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariablePermission) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariablePermission_PermissionType_OptionSetValues:
		return "PermissionType_OptionSetValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariablePermission) String() string {
	return e.PLC4XEnumName()
}
