/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ProtectionLevel {
  UNLOCK_REQUIRED((byte) 0, (String) "Unlock required from C-BUS port"),
  NO_WRITE_ACCESS((byte) 1, (String) "No write access via C-BUS port"),
  NONE((byte) 2, (String) "None"),
  READ_ONLY((byte) 3, (String) "Read only");
  private static final Map<Byte, ProtectionLevel> map;

  static {
    map = new HashMap<>();
    for (ProtectionLevel value : ProtectionLevel.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private final byte value;
  private final String description;

  ProtectionLevel(byte value, String description) {
    this.value = value;
    this.description = description;
  }

  public byte getValue() {
    return value;
  }

  public String getDescription() {
    return description;
  }

  public static ProtectionLevel firstEnumForFieldDescription(String fieldValue) {
    for (ProtectionLevel _val : ProtectionLevel.values()) {
      if (_val.getDescription().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<ProtectionLevel> enumsForFieldDescription(String fieldValue) {
    List<ProtectionLevel> _values = new ArrayList<>();
    for (ProtectionLevel _val : ProtectionLevel.values()) {
      if (_val.getDescription().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static ProtectionLevel enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
