/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum CIPClassID {
  Identity((int) 0x0001),
  MessageRouter((int) 0x0002),
  Assembly((int) 0x0004),
  Connection((int) 0x0005),
  ConnectionManager((int) 0x0006),
  Register((int) 0x0007),
  Parameter((int) 0x000F),
  ParameterGroup((int) 0x0010),
  AcknowledgeHandler((int) 0x002B),
  Selection((int) 0x002E),
  File((int) 0x0037),
  OriginatorConnectionList((int) 0x0045),
  ConnectionConfiguration((int) 0x00F3),
  Port((int) 0x00F4),
  DiscreteInputPoint((int) 0x0008),
  DiscreteOutputPoint((int) 0x0009),
  AnalogInputPoint((int) 0x000A),
  AnalogOutputPoint((int) 0x000B),
  PresenceSensing((int) 0x000E),
  Group((int) 0x0012),
  DiscreteInputGroup((int) 0x001D),
  DiscreteOutputGroup((int) 0x001E),
  DiscreteGroup((int) 0x001F),
  AnalogInputGroup((int) 0x0020),
  AnalogOutputGroup((int) 0x0021),
  AnalogGroup((int) 0x0022),
  PositionSensor((int) 0x0023),
  PositionControllerSupervisor((int) 0x0024),
  PositionController((int) 0x0025),
  BlockSequencer((int) 0x0026),
  CommandBlock((int) 0x0027),
  MotorData((int) 0x0028),
  ControlSupervisor((int) 0x0029),
  AcDcDrive((int) 0x002A),
  Overload((int) 0x002C),
  SDeviceSupervisor((int) 0x0030),
  SAnalogSensor((int) 0x0031),
  SAnalogActuator((int) 0x0032),
  SSingleStageController((int) 0x0033),
  SGasCalibration((int) 0x0034),
  SPartialPressure((int) 0x0038),
  SSensorCalibration((int) 0x0040),
  EventLog((int) 0x0041),
  MotionDeviceAxis((int) 0x0042),
  SafetyAnalogInputGroup((int) 0x004A),
  BaseEnergy((int) 0x004E),
  ElectricalEnergy((int) 0x004F),
  NonElectricalEnergy((int) 0x0050),
  PowerManagementObject((int) 0x0053),
  PowerCurtailmentObject((int) 0x005C),
  DeviceNet((int) 0x0003),
  Modbus((int) 0x0044),
  ModbusSerialLink((int) 0x0046),
  DeviceLevelRing((int) 0x0047),
  QOS((int) 0x0048),
  Sercos3Link((int) 0x004C),
  BaseSwitch((int) 0x0051),
  Snmp((int) 0x0052),
  PowerManagement((int) 0x0053),
  RstpBridge((int) 0x0054),
  RstpPort((int) 0x0055),
  ParallelRedundancyProtocol((int) 0x0056),
  PrpNodesTable((int) 0x0057),
  ControlNet((int) 0x00F0),
  ControlNetKeeper((int) 0x00F1),
  ControlNetScheduling((int) 0x00F2),
  TcpIpInterface((int) 0x00F5),
  EthernetLink((int) 0x00F6),
  CompoNetLink((int) 0x00F7),
  CompoNetRepeater((int) 0x00F8);
  private static final Map<Integer, CIPClassID> map;

  static {
    map = new HashMap<>();
    for (CIPClassID value : CIPClassID.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  CIPClassID(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static CIPClassID enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
