/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.Configuration;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.future.FutureTaskExt;
import org.apache.rocketmq.common.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.common.protocol.header.NotifyBrokerRoleChangedRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.controller.ElectMasterResponseHeader;
import org.apache.rocketmq.controller.BrokerHeartbeatManager;
import org.apache.rocketmq.controller.BrokerHousekeepingService;
import org.apache.rocketmq.controller.Controller;
import org.apache.rocketmq.controller.elect.impl.DefaultElectPolicy;
import org.apache.rocketmq.controller.impl.DLedgerController;
import org.apache.rocketmq.controller.impl.DefaultBrokerHeartbeatManager;
import org.apache.rocketmq.controller.processor.ControllerRequestProcessor;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class ControllerManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqController");
    private final ControllerConfig controllerConfig;
    private final NettyServerConfig nettyServerConfig;
    private final NettyClientConfig nettyClientConfig;
    private final BrokerHousekeepingService brokerHousekeepingService;
    private final Configuration configuration;
    private final RemotingClient remotingClient;
    private Controller controller;
    private BrokerHeartbeatManager heartbeatManager;
    private ExecutorService controllerRequestExecutor;
    private BlockingQueue<Runnable> controllerRequestThreadPoolQueue;

    public ControllerManager(ControllerConfig controllerConfig, NettyServerConfig nettyServerConfig, NettyClientConfig nettyClientConfig) {
        this.controllerConfig = controllerConfig;
        this.nettyServerConfig = nettyServerConfig;
        this.nettyClientConfig = nettyClientConfig;
        this.brokerHousekeepingService = new BrokerHousekeepingService(this);
        this.configuration = new Configuration(log, new Object[]{this.controllerConfig, this.nettyServerConfig});
        this.configuration.setStorePathFromConfig((Object)this.controllerConfig, "configStorePath");
        this.remotingClient = new NettyRemotingClient(nettyClientConfig);
    }

    public boolean initialize() {
        this.controllerRequestThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.controllerConfig.getControllerRequestThreadPoolQueueCapacity());
        this.controllerRequestExecutor = new ThreadPoolExecutor(this.controllerConfig.getControllerThreadPoolNums(), this.controllerConfig.getControllerThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.controllerRequestThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("ControllerRequestExecutorThread_")){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                return new FutureTaskExt(runnable, value);
            }
        };
        this.heartbeatManager = new DefaultBrokerHeartbeatManager(this.controllerConfig);
        if (StringUtils.isEmpty((CharSequence)this.controllerConfig.getControllerDLegerPeers())) {
            throw new IllegalArgumentException("Attribute value controllerDLegerPeers of ControllerConfig is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.controllerConfig.getControllerDLegerSelfId())) {
            throw new IllegalArgumentException("Attribute value controllerDLegerSelfId of ControllerConfig is null or empty");
        }
        this.controller = new DLedgerController(this.controllerConfig, this.heartbeatManager::isBrokerActive, this.nettyServerConfig, this.nettyClientConfig, this.brokerHousekeepingService, new DefaultElectPolicy(this.heartbeatManager::isBrokerActive, this.heartbeatManager::getBrokerLiveInfo));
        this.heartbeatManager.addBrokerLifecycleListener(this::onBrokerInactive);
        this.registerProcessor();
        return true;
    }

    private void onBrokerInactive(String clusterName, String brokerName, String brokerAddress, long brokerId) {
        block7: {
            if (brokerId == 0L) {
                if (this.controller.isLeaderState()) {
                    CompletableFuture<RemotingCommand> future = this.controller.electMaster(new ElectMasterRequestHeader(brokerName));
                    try {
                        RemotingCommand response = future.get(5L, TimeUnit.SECONDS);
                        ElectMasterResponseHeader responseHeader = (ElectMasterResponseHeader)response.readCustomHeader();
                        if (responseHeader == null) break block7;
                        log.info("Broker {}'s master {} shutdown, elect a new master done, result:{}", new Object[]{brokerName, brokerAddress, responseHeader});
                        if (StringUtils.isNotEmpty((CharSequence)responseHeader.getNewMasterAddress())) {
                            this.heartbeatManager.changeBrokerMetadata(clusterName, responseHeader.getNewMasterAddress(), 0L);
                        }
                        if (this.controllerConfig.isNotifyBrokerRoleChanged()) {
                            this.notifyBrokerRoleChanged(responseHeader, clusterName);
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    log.info("Broker{}' master shutdown", (Object)brokerName);
                }
            }
        }
    }

    public void notifyBrokerRoleChanged(ElectMasterResponseHeader electMasterResult, String clusterName) {
        BrokerMemberGroup memberGroup = electMasterResult.getBrokerMemberGroup();
        if (memberGroup != null) {
            String master = electMasterResult.getNewMasterAddress();
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{master}) && this.heartbeatManager.isBrokerActive(clusterName, master)) {
                this.doNotifyBrokerRoleChanged(master, 0L, electMasterResult);
            }
            Map brokerIdAddrs = memberGroup.getBrokerAddrs();
            for (Map.Entry broker : brokerIdAddrs.entrySet()) {
                if (((String)broker.getValue()).equals(master) || !this.heartbeatManager.isBrokerActive(clusterName, (String)broker.getValue())) continue;
                this.doNotifyBrokerRoleChanged((String)broker.getValue(), (Long)broker.getKey(), electMasterResult);
            }
        }
    }

    public void doNotifyBrokerRoleChanged(String brokerAddr, Long brokerId, ElectMasterResponseHeader responseHeader) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{brokerAddr})) {
            log.info("Try notify broker {} with id {} that role changed, responseHeader:{}", new Object[]{brokerAddr, brokerId, responseHeader});
            NotifyBrokerRoleChangedRequestHeader requestHeader = new NotifyBrokerRoleChangedRequestHeader(responseHeader.getNewMasterAddress(), responseHeader.getMasterEpoch(), responseHeader.getSyncStateSetEpoch(), brokerId.longValue());
            RemotingCommand request = RemotingCommand.createRequestCommand((int)1008, (CommandCustomHeader)requestHeader);
            try {
                this.remotingClient.invokeOneway(brokerAddr, request, 3000L);
            }
            catch (Exception e) {
                log.error("Failed to notify broker {} with id {} that role changed", new Object[]{brokerAddr, brokerId, e});
            }
        }
    }

    public void registerProcessor() {
        ControllerRequestProcessor controllerRequestProcessor = new ControllerRequestProcessor(this);
        RemotingServer controllerRemotingServer = this.controller.getRemotingServer();
        assert (controllerRemotingServer != null);
        controllerRemotingServer.registerProcessor(1001, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1002, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1003, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1004, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1005, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1006, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(904, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1009, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1010, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
        controllerRemotingServer.registerProcessor(1011, (NettyRequestProcessor)controllerRequestProcessor, this.controllerRequestExecutor);
    }

    public void start() {
        this.heartbeatManager.start();
        this.controller.startup();
        this.remotingClient.start();
    }

    public void shutdown() {
        this.heartbeatManager.shutdown();
        this.controllerRequestExecutor.shutdown();
        this.controller.shutdown();
        this.remotingClient.shutdown();
    }

    public BrokerHeartbeatManager getHeartbeatManager() {
        return this.heartbeatManager;
    }

    public ControllerConfig getControllerConfig() {
        return this.controllerConfig;
    }

    public Controller getController() {
        return this.controller;
    }

    public NettyServerConfig getNettyServerConfig() {
        return this.nettyServerConfig;
    }

    public NettyClientConfig getNettyClientConfig() {
        return this.nettyClientConfig;
    }

    public BrokerHousekeepingService getBrokerHousekeepingService() {
        return this.brokerHousekeepingService;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

