/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc;

import io.grpc.Server;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.proxy.common.StartAndShutdown;

public class GrpcServer
implements StartAndShutdown {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqProxy");
    private final Server server;

    protected GrpcServer(Server server) {
        this.server = server;
    }

    @Override
    public void start() throws Exception {
        this.server.start();
        log.info("grpc server start successfully.");
    }

    @Override
    public void shutdown() {
        try {
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
            log.info("grpc server shutdown successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

