/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.util.function.Supplier;
import org.apache.rocketmq.store.AppendMessageStatus;

public class AppendMessageResult {
    private AppendMessageStatus status;
    private long wroteOffset;
    private int wroteBytes;
    private String msgId;
    private Supplier<String> msgIdSupplier;
    private long storeTimestamp;
    private long logicsOffset;
    private long pagecacheRT = 0L;
    private int msgNum = 1;

    public AppendMessageResult(AppendMessageStatus status) {
        this(status, 0L, 0, "", 0L, 0L, 0L);
    }

    public AppendMessageResult(AppendMessageStatus status, long wroteOffset, int wroteBytes, String msgId, long storeTimestamp, long logicsOffset, long pagecacheRT) {
        this.status = status;
        this.wroteOffset = wroteOffset;
        this.wroteBytes = wroteBytes;
        this.msgId = msgId;
        this.storeTimestamp = storeTimestamp;
        this.logicsOffset = logicsOffset;
        this.pagecacheRT = pagecacheRT;
    }

    public AppendMessageResult(AppendMessageStatus status, long wroteOffset, int wroteBytes, Supplier<String> msgIdSupplier, long storeTimestamp, long logicsOffset, long pagecacheRT) {
        this.status = status;
        this.wroteOffset = wroteOffset;
        this.wroteBytes = wroteBytes;
        this.msgIdSupplier = msgIdSupplier;
        this.storeTimestamp = storeTimestamp;
        this.logicsOffset = logicsOffset;
        this.pagecacheRT = pagecacheRT;
    }

    public AppendMessageResult(AppendMessageStatus status, long wroteOffset, int wroteBytes, Supplier<String> msgIdSupplier, long storeTimestamp, long logicsOffset, long pagecacheRT, int msgNum) {
        this.status = status;
        this.wroteOffset = wroteOffset;
        this.wroteBytes = wroteBytes;
        this.msgIdSupplier = msgIdSupplier;
        this.storeTimestamp = storeTimestamp;
        this.logicsOffset = logicsOffset;
        this.pagecacheRT = pagecacheRT;
        this.msgNum = msgNum;
    }

    public long getPagecacheRT() {
        return this.pagecacheRT;
    }

    public void setPagecacheRT(long pagecacheRT) {
        this.pagecacheRT = pagecacheRT;
    }

    public boolean isOk() {
        return this.status == AppendMessageStatus.PUT_OK;
    }

    public AppendMessageStatus getStatus() {
        return this.status;
    }

    public void setStatus(AppendMessageStatus status) {
        this.status = status;
    }

    public long getWroteOffset() {
        return this.wroteOffset;
    }

    public void setWroteOffset(long wroteOffset) {
        this.wroteOffset = wroteOffset;
    }

    public int getWroteBytes() {
        return this.wroteBytes;
    }

    public void setWroteBytes(int wroteBytes) {
        this.wroteBytes = wroteBytes;
    }

    public String getMsgId() {
        if (this.msgId == null && this.msgIdSupplier != null) {
            this.msgId = this.msgIdSupplier.get();
        }
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public long getStoreTimestamp() {
        return this.storeTimestamp;
    }

    public void setStoreTimestamp(long storeTimestamp) {
        this.storeTimestamp = storeTimestamp;
    }

    public long getLogicsOffset() {
        return this.logicsOffset;
    }

    public void setLogicsOffset(long logicsOffset) {
        this.logicsOffset = logicsOffset;
    }

    public int getMsgNum() {
        return this.msgNum;
    }

    public void setMsgNum(int msgNum) {
        this.msgNum = msgNum;
    }

    public String toString() {
        return "AppendMessageResult{status=" + (Object)((Object)this.status) + ", wroteOffset=" + this.wroteOffset + ", wroteBytes=" + this.wroteBytes + ", msgId='" + this.msgId + '\'' + ", storeTimestamp=" + this.storeTimestamp + ", logicsOffset=" + this.logicsOffset + ", pagecacheRT=" + this.pagecacheRT + ", msgNum=" + this.msgNum + '}';
    }
}

