/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.common;

import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;

public class ProxyContext {
    public static final String INNER_ACTION_PREFIX = "Inner";
    private final Map<String, Object> value = new HashMap<String, Object>();

    public static ProxyContext create() {
        return new ProxyContext();
    }

    public static ProxyContext createForInner(String actionName) {
        return ProxyContext.create().setAction(INNER_ACTION_PREFIX + actionName);
    }

    public static ProxyContext createForInner(Class<?> clazz) {
        return ProxyContext.createForInner(clazz.getSimpleName());
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    public ProxyContext withVal(String key, Object val) {
        this.value.put(key, val);
        return this;
    }

    public <T> T getVal(String key) {
        return (T)this.value.get(key);
    }

    public ProxyContext setLocalAddress(String localAddress) {
        this.withVal("local-address", localAddress);
        return this;
    }

    public String getLocalAddress() {
        return (String)this.getVal("local-address");
    }

    public ProxyContext setRemoteAddress(String remoteAddress) {
        this.withVal("remote-address", remoteAddress);
        return this;
    }

    public String getRemoteAddress() {
        return (String)this.getVal("remote-address");
    }

    public ProxyContext setClientID(String clientID) {
        this.withVal("client-id", clientID);
        return this;
    }

    public String getClientID() {
        return (String)this.getVal("client-id");
    }

    public ProxyContext setChannel(Channel channel) {
        this.withVal("channel", channel);
        return this;
    }

    public Channel getChannel() {
        return (Channel)this.getVal("channel");
    }

    public ProxyContext setLanguage(String language) {
        this.withVal("language", language);
        return this;
    }

    public String getLanguage() {
        return (String)this.getVal("language");
    }

    public ProxyContext setClientVersion(String clientVersion) {
        this.withVal("client-version", clientVersion);
        return this;
    }

    public String getClientVersion() {
        return (String)this.getVal("client-version");
    }

    public ProxyContext setRemainingMs(Long remainingMs) {
        this.withVal("remaining-ms", remainingMs);
        return this;
    }

    public Long getRemainingMs() {
        return (Long)this.getVal("remaining-ms");
    }

    public ProxyContext setAction(String action) {
        this.withVal("action", action);
        return this;
    }

    public String getAction() {
        return (String)this.getVal("action");
    }

    public ProxyContext setProtocolType(String protocol) {
        this.withVal("protocol-type", protocol);
        return this;
    }

    public String getProtocolType() {
        return (String)this.getVal("protocol-type");
    }
}

