/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.subscription;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.common.config.RocksDBConfigManager;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;

public class RocksDBSubscriptionGroupManager
extends SubscriptionGroupManager {
    public RocksDBSubscriptionGroupManager(BrokerController brokerController) {
        super(brokerController, false);
        this.rocksDBConfigManager = new RocksDBConfigManager(brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs());
    }

    public boolean load() {
        if (!this.rocksDBConfigManager.load(this.configFilePath(), this::decode0)) {
            return false;
        }
        this.init();
        return true;
    }

    public boolean stop() {
        return this.rocksDBConfigManager.stop();
    }

    @Override
    protected SubscriptionGroupConfig putSubscriptionGroupConfig(SubscriptionGroupConfig subscriptionGroupConfig) {
        String groupName = subscriptionGroupConfig.getGroupName();
        SubscriptionGroupConfig oldConfig = this.subscriptionGroupTable.put(groupName, subscriptionGroupConfig);
        try {
            byte[] keyBytes = groupName.getBytes(DataConverter.CHARSET_UTF8);
            byte[] valueBytes = JSON.toJSONBytes((Object)subscriptionGroupConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
            this.rocksDBConfigManager.put(keyBytes, keyBytes.length, valueBytes);
        }
        catch (Exception e) {
            log.error("kv put sub Failed, {}", (Object)subscriptionGroupConfig.toString());
        }
        return oldConfig;
    }

    @Override
    protected SubscriptionGroupConfig putSubscriptionGroupConfigIfAbsent(SubscriptionGroupConfig subscriptionGroupConfig) {
        String groupName = subscriptionGroupConfig.getGroupName();
        SubscriptionGroupConfig oldConfig = this.subscriptionGroupTable.putIfAbsent(groupName, subscriptionGroupConfig);
        if (oldConfig == null) {
            try {
                byte[] keyBytes = groupName.getBytes(DataConverter.CHARSET_UTF8);
                byte[] valueBytes = JSON.toJSONBytes((Object)subscriptionGroupConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
                this.rocksDBConfigManager.put(keyBytes, keyBytes.length, valueBytes);
            }
            catch (Exception e) {
                log.error("kv put sub Failed, {}", (Object)subscriptionGroupConfig.toString());
            }
        }
        return oldConfig;
    }

    @Override
    protected SubscriptionGroupConfig removeSubscriptionGroupConfig(String groupName) {
        SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)this.subscriptionGroupTable.remove(groupName);
        try {
            this.rocksDBConfigManager.delete(groupName.getBytes(DataConverter.CHARSET_UTF8));
        }
        catch (Exception e) {
            log.error("kv delete sub Failed, {}", (Object)subscriptionGroupConfig.toString());
        }
        return subscriptionGroupConfig;
    }

    protected void decode0(byte[] key, byte[] body) {
        String groupName = new String(key, DataConverter.CHARSET_UTF8);
        SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)JSON.parseObject((byte[])body, SubscriptionGroupConfig.class, (Feature[])new Feature[0]);
        this.subscriptionGroupTable.put(groupName, subscriptionGroupConfig);
        log.info("load exist local sub, {}", (Object)subscriptionGroupConfig.toString());
    }

    public synchronized void persist() {
        if (this.brokerController.getMessageStoreConfig().isRealTimePersistRocksDBConfig()) {
            this.rocksDBConfigManager.flushWAL();
        }
    }

    @Override
    public String configFilePath() {
        return this.brokerController.getMessageStoreConfig().getStorePathRootDir() + File.separator + "config" + File.separator + "subscriptionGroups" + File.separator;
    }
}

