/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import java.util.UUID;
import org.apache.rocketmq.shaded.io.grpc.CallOptions;
import org.apache.rocketmq.shaded.io.grpc.Channel;
import org.apache.rocketmq.shaded.io.grpc.ClientCall;
import org.apache.rocketmq.shaded.io.grpc.ClientInterceptor;
import org.apache.rocketmq.shaded.io.grpc.ForwardingClientCall;
import org.apache.rocketmq.shaded.io.grpc.ForwardingClientCallListener;
import org.apache.rocketmq.shaded.io.grpc.Metadata;
import org.apache.rocketmq.shaded.io.grpc.MethodDescriptor;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements ClientInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingInterceptor.class);
    private static final LoggingInterceptor INSTANCE = new LoggingInterceptor();

    public static LoggingInterceptor getInstance() {
        return INSTANCE;
    }

    public <T, E> ClientCall<T, E> interceptCall(MethodDescriptor<T, E> method, CallOptions callOptions, Channel next) {
        final String rpcId = UUID.randomUUID().toString();
        final String authority = next.authority();
        final String serviceName = method.getServiceName();
        final String methodName = method.getBareMethodName();
        return new ForwardingClientCall.SimpleForwardingClientCall<T, E>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<E> responseListener, Metadata headers) {
                LOGGER.trace("gRPC request header, rpcId={}, serviceName={}, methodName={}, authority={}, headers={}", rpcId, serviceName, methodName, authority, headers);
                ForwardingClientCallListener.SimpleForwardingClientCallListener observabilityListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<E>(responseListener){

                    @Override
                    public void onMessage(E response) {
                        LOGGER.trace("gRPC response, rpcId={}, serviceName={}, methodName={}, content:\n{}", rpcId, serviceName, methodName, response);
                        super.onMessage(response);
                    }

                    @Override
                    public void onHeaders(Metadata headers) {
                        LOGGER.trace("gRPC response header, rpcId={}, serviceName={}, methodName={}, authority={}, headers={}", rpcId, serviceName, methodName, authority, headers);
                        super.onHeaders(headers);
                    }
                };
                super.start(observabilityListener, headers);
            }

            @Override
            public void sendMessage(T request) {
                LOGGER.trace("gRPC request, rpcId={}, serviceName={}, methodName={}, content:\n{}", rpcId, serviceName, methodName, request);
                super.sendMessage(request);
            }
        };
    }
}

