/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data;

import javax.annotation.concurrent.Immutable;
import org.apache.rocketmq.shaded.com.google.auto.value.AutoValue;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.Data;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.DoublePointData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.GaugeData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.HistogramData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.LongPointData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.MetricDataType;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.SumData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.SummaryData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.AutoValue_ImmutableMetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

@Immutable
@AutoValue
public abstract class ImmutableMetricData
implements MetricData {
    public static MetricData createDoubleGauge(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description, String unit, GaugeData<DoublePointData> data) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description, unit, MetricDataType.DOUBLE_GAUGE, data);
    }

    public static MetricData createLongGauge(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description, String unit, GaugeData<LongPointData> data) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description, unit, MetricDataType.LONG_GAUGE, data);
    }

    public static MetricData createDoubleSum(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description, String unit, SumData<DoublePointData> data) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description, unit, MetricDataType.DOUBLE_SUM, data);
    }

    public static MetricData createLongSum(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description, String unit, SumData<LongPointData> data) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description, unit, MetricDataType.LONG_SUM, data);
    }

    public static MetricData createDoubleSummary(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description, String unit, SummaryData data) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description, unit, MetricDataType.SUMMARY, data);
    }

    public static MetricData createDoubleHistogram(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description, String unit, HistogramData data) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description, unit, MetricDataType.HISTOGRAM, data);
    }

    public static MetricData createExponentialHistogram(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description, String unit, ExponentialHistogramData data) {
        return ImmutableMetricData.create(resource, instrumentationScopeInfo, name, description, unit, MetricDataType.EXPONENTIAL_HISTOGRAM, data);
    }

    static ImmutableMetricData create(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, String name, String description, String unit, MetricDataType type, Data<?> data) {
        return new AutoValue_ImmutableMetricData(resource, instrumentationScopeInfo, name, description, unit, type, data);
    }

    ImmutableMetricData() {
    }
}

