/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.example;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.apis.StaticSessionCredentialsProvider;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.FilterExpressionType;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumer;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSimpleConsumerExample {
    private static final Logger log = LoggerFactory.getLogger(AsyncSimpleConsumerExample.class);

    private AsyncSimpleConsumerExample() {
    }

    public static void main(String[] args) throws ClientException {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        String accessKey = "yourAccessKey";
        String secretKey = "yourSecretKey";
        StaticSessionCredentialsProvider sessionCredentialsProvider = new StaticSessionCredentialsProvider(accessKey, secretKey);
        String endpoints = "foobar.com:8080";
        ClientConfiguration clientConfiguration = ClientConfiguration.newBuilder().setEndpoints(endpoints).setCredentialProvider((SessionCredentialsProvider)sessionCredentialsProvider).build();
        String consumerGroup = "yourConsumerGroup";
        Duration awaitDuration = Duration.ofSeconds(30L);
        String tag = "yourMessageTagA";
        String topic = "yourTopic";
        FilterExpression filterExpression = new FilterExpression(tag, FilterExpressionType.TAG);
        SimpleConsumer consumer = provider.newSimpleConsumerBuilder().setClientConfiguration(clientConfiguration).setConsumerGroup(consumerGroup).setAwaitDuration(awaitDuration).setSubscriptionExpressions(Collections.singletonMap(topic, filterExpression)).build();
        int maxMessageNum = 16;
        Duration invisibleDuration = Duration.ofSeconds(15L);
        ExecutorService receiveCallbackExecutor = Executors.newCachedThreadPool();
        ExecutorService ackCallbackExecutor = Executors.newCachedThreadPool();
        while (true) {
            CompletableFuture future0 = consumer.receiveAsync(maxMessageNum, invisibleDuration);
            future0.whenCompleteAsync((messages, throwable) -> {
                if (null != throwable) {
                    log.error("Failed to receive message from remote", throwable);
                    return;
                }
                log.info("Received {} message(s)", (Object)messages.size());
                Map<MessageView, CompletableFuture> map = messages.stream().collect(Collectors.toMap(message -> message, arg_0 -> ((SimpleConsumer)consumer).ackAsync(arg_0)));
                for (Map.Entry<MessageView, CompletableFuture> entry : map.entrySet()) {
                    MessageId messageId = entry.getKey().getMessageId();
                    CompletableFuture future = entry.getValue();
                    future.whenCompleteAsync((v, t) -> {
                        if (null != t) {
                            log.error("Message is failed to be acknowledged, messageId={}", (Object)messageId, t);
                            return;
                        }
                        log.info("Message is acknowledged successfully, messageId={}", (Object)messageId);
                    }, (Executor)ackCallbackExecutor);
                }
            }, (Executor)receiveCallbackExecutor);
        }
    }
}

