/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import io.grpc.Metadata;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.SessionCredentials;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.misc.MetadataUtils;
import org.apache.rocketmq.client.java.misc.RequestIdGenerator;
import org.apache.rocketmq.client.java.misc.Utilities;
import org.apache.rocketmq.client.java.rpc.TLSHelper;

public class Signature {
    public static final String AUTHORIZATION_KEY = "authorization";
    public static final String DATE_TIME_KEY = "x-mq-date-time";
    public static final String SESSION_TOKEN_KEY = "x-mq-session-token";
    public static final String CLIENT_ID_KEY = "x-mq-client-id";
    public static final String REQUEST_ID_KEY = "x-mq-request-id";
    public static final String LANGUAGE_KEY = "x-mq-language";
    public static final String CLIENT_VERSION_KEY = "x-mq-client-version";
    public static final String PROTOCOL_VERSION = "x-mq-protocol";
    public static final String ALGORITHM = "MQv2-HMAC-SHA1";
    public static final String CREDENTIAL = "Credential";
    public static final String SIGNED_HEADERS = "SignedHeaders";
    public static final String SIGNATURE = "Signature";
    public static final String DATE_TIME_FORMAT = "yyyyMMdd'T'HHmmss'Z'";

    private Signature() {
    }

    public static Metadata sign(ClientConfiguration config, ClientId clientId) throws NoSuchAlgorithmException, InvalidKeyException {
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)LANGUAGE_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)"JAVA");
        metadata.put(Metadata.Key.of((String)PROTOCOL_VERSION, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)Utilities.getProtocolVersion());
        metadata.put(Metadata.Key.of((String)CLIENT_VERSION_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)MetadataUtils.getVersion());
        String dateTime = new SimpleDateFormat(DATE_TIME_FORMAT).format(new Date());
        metadata.put(Metadata.Key.of((String)DATE_TIME_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)dateTime);
        String requestId = RequestIdGenerator.getInstance().next();
        metadata.put(Metadata.Key.of((String)REQUEST_ID_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)requestId);
        metadata.put(Metadata.Key.of((String)CLIENT_ID_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)clientId.toString());
        Optional optionalSessionCredentialsProvider = config.getCredentialsProvider();
        if (!optionalSessionCredentialsProvider.isPresent()) {
            return metadata;
        }
        SessionCredentialsProvider provider = (SessionCredentialsProvider)optionalSessionCredentialsProvider.get();
        SessionCredentials credentials = provider.getSessionCredentials();
        if (null == credentials) {
            return metadata;
        }
        Optional optionalSecurityToken = credentials.tryGetSecurityToken();
        optionalSecurityToken.ifPresent(s -> metadata.put(Metadata.Key.of((String)SESSION_TOKEN_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), s));
        String accessKey = credentials.getAccessKey();
        String accessSecret = credentials.getAccessSecret();
        if (StringUtils.isBlank((CharSequence)accessKey)) {
            return metadata;
        }
        if (StringUtils.isBlank((CharSequence)accessSecret)) {
            return metadata;
        }
        String sign = TLSHelper.sign(accessSecret, dateTime);
        String authorization = "MQv2-HMAC-SHA1 Credential=" + accessKey + ", " + SIGNED_HEADERS + "=" + DATE_TIME_KEY + ", " + SIGNATURE + "=" + sign;
        metadata.put(Metadata.Key.of((String)AUTHORIZATION_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)authorization);
        return metadata;
    }
}

