/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.rocketmq.streams.common.checkpoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.streams.common.context.MessageOffset;

/**
 * @create 2021-08-11 15:51:50
 * @description
 */
public class SourceState {

    protected String sourceName;
    protected Map<String, MessageOffset> queueId2Offsets = new HashMap<>();

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Map<String, MessageOffset> getQueueId2Offsets() {
        return queueId2Offsets;
    }

    public void setQueueId2Offsets(
        Map<String, MessageOffset> queueId2Offsets) {
        this.queueId2Offsets = queueId2Offsets;
    }

    @Override
    public String toString() {
        return "SourceState{" +
            "sourceName='" + sourceName + '\'' +
            ", queueId2Offsets=" + queueId2Offsets +
            '}';
    }
}
