/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class NameBasedDefinitionProvider
implements CompilerPass {
    protected final AbstractCompiler compiler;
    protected final Multimap<String, DefinitionsRemover.Definition> definitionsByName;
    protected final Map<Node, DefinitionSite> definitionSitesByDefinitionSiteNode;
    protected final Multimap<Node, DefinitionSite> definitionSitesByScopeNode;
    protected final Set<Node> definitionNodes;
    protected final boolean allowComplexFunctionDefs;
    protected boolean hasProcessBeenRun = false;

    public NameBasedDefinitionProvider(AbstractCompiler compiler, boolean allowComplexFunctionDefs) {
        this.compiler = compiler;
        this.allowComplexFunctionDefs = allowComplexFunctionDefs;
        int numInputs = compiler.getNumberOfInputs();
        this.definitionsByName = LinkedHashMultimap.create(numInputs * 15, 1);
        int estimatedDefinitionSites = numInputs * 22;
        this.definitionSitesByDefinitionSiteNode = Maps.newLinkedHashMapWithExpectedSize(estimatedDefinitionSites);
        this.definitionSitesByScopeNode = HashMultimap.create(estimatedDefinitionSites, 1);
        this.definitionNodes = Sets.newHashSetWithExpectedSize(estimatedDefinitionSites);
    }

    @Override
    public void process(Node externs, Node source) {
        Preconditions.checkState(!this.hasProcessBeenRun, "The definition provider is already initialized.");
        this.hasProcessBeenRun = true;
        NodeTraversal.traverse(this.compiler, externs, new DefinitionGatheringCallback(true));
        this.dropUntypedExterns();
        NodeTraversal.traverse(this.compiler, source, new DefinitionGatheringCallback(false));
    }

    public void rebuildScopeRoots(List<Node> changedScopeRoots, List<Node> deletedScopeRoots) {
        for (Node scopeRoot : Iterables.concat(deletedScopeRoots, changedScopeRoots)) {
            for (DefinitionSite definitionSite : this.definitionSitesByScopeNode.removeAll(scopeRoot)) {
                DefinitionsRemover.Definition definition = definitionSite.definition;
                this.definitionNodes.remove(definitionSite.node);
                this.definitionsByName.remove(definition.getSimplifiedName(), definition);
                this.definitionSitesByDefinitionSiteNode.remove(definitionSite.node);
            }
        }
        DefinitionGatheringCallback cb = new DefinitionGatheringCallback();
        NodeTraversal.traverseScopeRoots(this.compiler, null, changedScopeRoots, cb, cb, false);
    }

    private boolean jsdocContainsDeclarations(Node node) {
        JSDocInfo info = node.getJSDocInfo();
        return info != null && info.containsDeclaration();
    }

    private void dropUntypedExterns() {
        for (String name : this.definitionsByName.keySet()) {
            block1: for (DefinitionsRemover.Definition definition : new ArrayList<DefinitionsRemover.Definition>(this.definitionsByName.get(name))) {
                Node definitionNode;
                if (!(definition instanceof DefinitionsRemover.ExternalNameOnlyDefinition) || this.jsdocContainsDeclarations(definitionNode = definition.getLValue())) continue;
                for (DefinitionsRemover.Definition previousDefinition : this.definitionsByName.get(name)) {
                    if (previousDefinition == definition || !definitionNode.matchesQualifiedName(previousDefinition.getLValue())) continue;
                    this.definitionsByName.remove(name, definition);
                    DefinitionSite definitionSite = this.definitionSitesByDefinitionSiteNode.remove(definitionNode);
                    Node scopeNode = NodeUtil.getEnclosingChangeScopeRoot(definitionNode);
                    this.definitionSitesByScopeNode.remove(scopeNode, definitionSite);
                    Preconditions.checkNotNull(definitionSite);
                    continue block1;
                }
            }
        }
    }

    public Collection<DefinitionsRemover.Definition> getDefinitionsReferencedAt(Node useSiteNode) {
        String name;
        String propName;
        Preconditions.checkState(this.hasProcessBeenRun, "Hasn't been initialized with process() yet.");
        Preconditions.checkArgument(useSiteNode.isGetProp() || useSiteNode.isName(), useSiteNode);
        if (this.definitionNodes.contains(useSiteNode)) {
            return ImmutableList.of();
        }
        if (useSiteNode.isGetProp() && ((propName = useSiteNode.getLastChild().getString()).equals("apply") || propName.equals("call"))) {
            useSiteNode = useSiteNode.getFirstChild();
        }
        if ((name = NameBasedDefinitionProvider.getSimplifiedName(useSiteNode)) != null) {
            return this.definitionsByName.get(name);
        }
        return ImmutableList.of();
    }

    private void addDefinition(String name, DefinitionsRemover.Definition definition, Node definitionSiteNode, NodeTraversal traversal) {
        Node definitionNode = definition.getLValue();
        this.definitionNodes.add(definitionNode);
        this.definitionsByName.put(name, definition);
        DefinitionSite definitionSite = new DefinitionSite(definitionSiteNode, definition, traversal.getModule(), traversal.inGlobalScope(), definition.isExtern());
        this.definitionSitesByDefinitionSiteNode.put(definitionSiteNode, definitionSite);
        Node scopeNode = NodeUtil.getEnclosingChangeScopeRoot(definitionSiteNode);
        this.definitionSitesByScopeNode.put(scopeNode, definitionSite);
    }

    @Nullable
    public static String getSimplifiedName(Node node) {
        if (node.isName()) {
            String name = node.getString();
            if (name != null && !name.isEmpty()) {
                return name;
            }
            return null;
        }
        if (node.isGetProp()) {
            return "this." + node.getLastChild().getString();
        }
        if (node.isMemberFunctionDef()) {
            return "this." + node.getString();
        }
        return null;
    }

    public Collection<DefinitionSite> getDefinitionSites() {
        Preconditions.checkState(this.hasProcessBeenRun, "Hasn't been initialized with process() yet.");
        return this.definitionSitesByDefinitionSiteNode.values();
    }

    public DefinitionSite getDefinitionForFunction(Node function) {
        Preconditions.checkState(this.hasProcessBeenRun, "Hasn't been initialized with process() yet.");
        Preconditions.checkState(function.isFunction());
        return this.definitionSitesByDefinitionSiteNode.get(NodeUtil.getNameNode(function));
    }

    private class DefinitionGatheringCallback
    implements NodeTraversal.Callback,
    NodeTraversal.ChangeScopeRootCallback {
        private boolean inExterns;

        DefinitionGatheringCallback() {
        }

        DefinitionGatheringCallback(boolean inExterns) {
            this.inExterns = inExterns;
        }

        @Override
        public void enterChangeScopeRoot(AbstractCompiler compiler, Node root) {
            this.inExterns = root.isFromExterns();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (this.inExterns) {
                if (n.isFunction() && !n.getFirstChild().isName()) {
                    return false;
                }
                if (parent != null && parent.isFunction() && n != parent.getFirstChild()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            if (this.inExterns) {
                this.visitExterns(traversal, node);
            } else {
                this.visitCode(traversal, node);
            }
        }

        private void visitExterns(NodeTraversal traversal, Node node) {
            String name;
            DefinitionsRemover.Definition definition;
            if (node.getJSDocInfo() != null) {
                for (Node typeRoot : node.getJSDocInfo().getTypeNodes()) {
                    traversal.traverse(typeRoot);
                }
            }
            if ((definition = DefinitionsRemover.getDefinition(node, true)) != null && (name = definition.getSimplifiedName()) != null) {
                Node rValue = definition.getRValue();
                if (rValue != null && !NodeUtil.isImmutableValue(rValue) && !rValue.isFunction()) {
                    DefinitionsRemover.UnknownDefinition unknownDefinition = new DefinitionsRemover.UnknownDefinition(definition.getLValue(), true);
                    definition = unknownDefinition;
                }
                NameBasedDefinitionProvider.this.addDefinition(name, definition, node, traversal);
            }
        }

        private void visitCode(NodeTraversal traversal, Node node) {
            String name;
            DefinitionsRemover.Definition definition = DefinitionsRemover.getDefinition(node, false);
            if (definition != null && (name = definition.getSimplifiedName()) != null) {
                Node rValue = definition.getRValue();
                if (rValue != null && !NodeUtil.isImmutableValue(rValue) && !this.isKnownFunctionDefinition(rValue)) {
                    definition = new DefinitionsRemover.UnknownDefinition(definition.getLValue(), false);
                }
                NameBasedDefinitionProvider.this.addDefinition(name, definition, node, traversal);
            }
        }

        boolean isKnownFunctionDefinition(Node n) {
            switch (n.getToken()) {
                case FUNCTION: {
                    return true;
                }
                case HOOK: {
                    return NameBasedDefinitionProvider.this.allowComplexFunctionDefs && this.isKnownFunctionDefinition(n.getSecondChild()) && this.isKnownFunctionDefinition(n.getLastChild());
                }
            }
            return false;
        }
    }
}

