/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.tasks;

import java.io.File;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.tasks.configuration.CompilationConfiguration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.apache.tools.ant.util.ResourceUtils;

public class Compilation {
    private final String BASIC_APPLICATION_CLASS = "Application";
    private final String MXML2006_PREFIX = "mx";
    private final String MXML2006_NAMESPACE = "xmlns:mx=\"http://www.adobe.com/2006/mxml\"";
    private final String MXML2009_PREFIX = "fx";
    private final String MXML2009_NAMESPACE = "xmlns:fx=\"http://ns.adobe.com/mxml/2009\"";
    private final String BASIC_PREFIX = "js";
    private final String BASIC_NAMESPACE = "xmlns:js=\"library://ns.apache.org/royale/basic\"";
    private final String CI_LISTENER = "CIListener";
    private final String AIR_CI_LISTENER = "AirCIListener";
    private final String TESTRUNNER_TEMPLATE = "TestRunner.template";
    private final String TESTRUNNER_FILE = "TestRunner.mxml";
    private final String MXMLC_RELATIVE_PATH = "lib/mxmlc.jar";
    private final String FRAMEWORKS_RELATIVE_PATH = "frameworks";
    private final String SWF_FILENAME = "TestRunner.swf";
    private CompilationConfiguration configuration;
    private Project project;
    private String mxmlcPath;

    public Compilation(Project project, CompilationConfiguration configuration) {
        this.project = project;
        this.configuration = configuration;
        this.mxmlcPath = configuration.getRoyaleHome().getAbsolutePath() + File.separatorChar + "lib/mxmlc.jar";
    }

    public File compile() throws BuildException {
        this.configuration.log();
        File runnerFile = this.generateTestRunnerFromTemplate(this.configuration.getWorkingDir());
        File finalFile = new File(this.configuration.getWorkingDir().getAbsolutePath() + File.separatorChar + "TestRunner.swf");
        Java compilationTask = this.createJavaTask(runnerFile, finalFile);
        LoggingUtil.log("Compiling test classes: [" + this.configuration.getTestSources().getCanonicalClasses(", ") + "]", true);
        LoggingUtil.log(compilationTask.getCommandLine().describeCommand());
        if (compilationTask.executeJava() != 0) {
            throw new BuildException("Compilation failed:\n" + this.project.getProperty("MXMLC_ERROR"));
        }
        return finalFile;
    }

    private File generateTestRunnerFromTemplate(File workingDir) throws BuildException {
        try {
            int sdkVersion = this.getSDKVersion();
            String namespaces = "xmlns:fx=\"http://ns.adobe.com/mxml/2009\"\nxmlns:js=\"library://ns.apache.org/royale/basic\"";
            String ciListener = this.configuration.getPlayer().equals("flash") ? "CIListener" : "AirCIListener";
            File runner = new File(workingDir.getAbsolutePath() + File.separatorChar + "TestRunner.mxml");
            URLResource template = new URLResource(this.getClass().getResource("/TestRunner.template"));
            FilterSet filters = new FilterSet();
            filters.addFilter("APPLICATION_PREFIX", "js");
            filters.addFilter("APPLICATION_CLASS", "Application");
            filters.addFilter("NAMESPACES", namespaces);
            filters.addFilter("MXML_PREFIX", "fx");
            filters.addFilter("CI_LISTENER_CLASS", ciListener);
            filters.addFilter("CLASS_REFS", this.configuration.getTestSources().getClasses());
            filters.addFilter("IMPORT_REFS", this.configuration.getTestSources().getImports());
            ResourceUtils.copyResource((Resource)template, (Resource)new FileResource(runner), (FilterSetCollection)new FilterSetCollection(filters), null, (boolean)true, (boolean)false, null, null, (Project)this.project);
            LoggingUtil.log("Created test runner at [" + runner.getAbsolutePath() + "]");
            return runner;
        }
        catch (Exception e) {
            throw new BuildException("Could not create test runner from template.", (Throwable)e);
        }
    }

    private int getSDKVersion() {
        String outputProperty = "SDK_VERSION";
        Java task = new Java();
        task.setFork(true);
        task.setFailonerror(true);
        task.setJar(new File(this.mxmlcPath));
        task.setProject(this.project);
        task.setDir(this.project.getBaseDir());
        task.setOutputproperty(outputProperty);
        Commandline.Argument versionArgument = task.createArg();
        versionArgument.setValue("--version");
        task.execute();
        String output = this.project.getProperty(outputProperty);
        int prefixIndex = output.indexOf("Version ");
        int version = Integer.parseInt(output.substring(prefixIndex + 8, prefixIndex + 9));
        LoggingUtil.log("Found SDK version: " + version);
        return version;
    }

    private Java createJavaTask(File runnerFile, File finalFile) {
        String frameworksPath = this.configuration.getRoyaleHome().getAbsolutePath() + File.separatorChar + "frameworks";
        Java task = new Java();
        task.setFork(true);
        task.setFailonerror(true);
        task.setJar(new File(this.mxmlcPath));
        task.setProject(this.project);
        task.setDir(this.project.getBaseDir());
        task.setMaxmemory("256M");
        task.setErrorProperty("MXMLC_ERROR");
        Commandline.Argument royaleLibArgument = task.createArg();
        royaleLibArgument.setLine("+royalelib \"" + frameworksPath + "\"");
        if (this.configuration.getPlayer().equals("air")) {
            Commandline.Argument airConfigArgument = task.createArg();
            airConfigArgument.setValue("+configname=air");
        }
        Commandline.Argument outputFile = task.createArg();
        outputFile.setLine("-output \"" + finalFile.getAbsolutePath() + "\"");
        Commandline.Argument sourcePath = task.createArg();
        sourcePath.setLine("-source-path " + this.configuration.getSources().getPathElements(" ") + " " + this.configuration.getTestSources().getPathElements(" "));
        this.determineLibraryPath(task);
        this.determineLoadConfigArgument(task);
        Commandline.Argument debug = task.createArg();
        debug.setLine("-debug=" + this.configuration.getDebug());
        Commandline.Argument headlessServer = task.createArg();
        headlessServer.setLine("-headless-server=true");
        Commandline.Argument mainFile = task.createArg();
        mainFile.setValue(runnerFile.getAbsolutePath());
        return task;
    }

    private void determineLoadConfigArgument(Java java) {
        if (this.configuration.getLoadConfig() != null) {
            Commandline.Argument argument = java.createArg();
            argument.setLine(this.configuration.getLoadConfig().getCommandLineArgument());
        }
    }

    private void determineLibraryPath(Java java) {
        if (!this.configuration.getLibraries().getPathElements(" -library-path+=").isEmpty()) {
            Commandline.Argument libraryPath = java.createArg();
            libraryPath.setLine("-library-path+=" + this.configuration.getLibraries().getPathElements(" -library-path+="));
        }
    }
}

