/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RenameVarsWithModuleSupport;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;

class ShadowVariablesWithModuleSupport
implements CompilerPass {
    private final Multimap<Node, String> scopeUpRefMap = HashMultimap.create();
    private final Multimap<Var, Reference> varToNameUsage = HashMultimap.create();
    private final AbstractCompiler compiler;
    private final SortedSet<RenameVarsWithModuleSupport.Assignment> varsByFrequency;
    private final Map<String, RenameVarsWithModuleSupport.Assignment> assignments;
    private final Map<Node, String> oldPseudoNameMap;
    private final Map<Node, String> deltaPseudoNameMap;

    ShadowVariablesWithModuleSupport(AbstractCompiler compiler, Map<String, RenameVarsWithModuleSupport.Assignment> assignments, SortedSet<RenameVarsWithModuleSupport.Assignment> varsByFrequency, Map<Node, String> pseudoNameMap) {
        this.compiler = compiler;
        this.assignments = assignments;
        this.varsByFrequency = varsByFrequency;
        this.oldPseudoNameMap = pseudoNameMap;
        this.deltaPseudoNameMap = new LinkedHashMap<Node, String>();
    }

    public void process(Node externs, Node root) {
        NodeTraversal.traverse((AbstractCompiler)this.compiler, (Node)root, (NodeTraversal.Callback)new GatherReferenceInfo());
        NodeTraversal.traverse((AbstractCompiler)this.compiler, (Node)root, (NodeTraversal.Callback)new DoShadowVariables());
        if (this.oldPseudoNameMap != null) {
            this.oldPseudoNameMap.putAll(this.deltaPseudoNameMap);
        }
    }

    private class GatherReferenceInfo
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherReferenceInfo() {
        }

        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName((Node)n)) {
                return;
            }
            if (t.inGlobalScope()) {
                return;
            }
            Scope scope = t.getScope();
            Var var = (Var)scope.getVar(n.getString());
            if (var == null) {
                return;
            }
            if (((Scope)var.getScope()).isGlobal()) {
                return;
            }
            if (var.getScope() != scope) {
                for (Scope s = scope; s != var.getScope() && s.isLocal(); s = (Scope)s.getParent()) {
                    ShadowVariablesWithModuleSupport.this.scopeUpRefMap.put(s.getRootNode(), var.name);
                }
            } else {
                ShadowVariablesWithModuleSupport.this.scopeUpRefMap.put(t.getScopeRoot(), var.name);
            }
            if (scope.isFunctionScope() && var.getScope() == scope) {
                ShadowVariablesWithModuleSupport.this.scopeUpRefMap.put(scope.getRootNode().getLastChild(), var.name);
            }
            ShadowVariablesWithModuleSupport.this.varToNameUsage.put(var, new Reference(n, scope));
        }
    }

    private class DoShadowVariables
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private DoShadowVariables() {
        }

        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            Node scopeRoot = t.getScopeRoot();
            if (scopeRoot.isFunction() && NodeUtil.getEnclosingFunction((Node)scopeRoot.getParent()) == null || NodeUtil.isFunctionBlock((Node)scopeRoot) && NodeUtil.getEnclosingFunction((Node)scopeRoot.getGrandparent()) == null) {
                return;
            }
            Scope s = t.getScope();
            for (Var var : s.getVarIterable()) {
                RenameVarsWithModuleSupport.Assignment bestShadow;
                RenameVarsWithModuleSupport.Assignment localAssignment;
                if (var.isBleedingFunction() || var.isCatch() || ShadowVariablesWithModuleSupport.this.compiler.getCodingConvention().isExported(var.name, s.isLocal()) || (localAssignment = ShadowVariablesWithModuleSupport.this.assignments.get(var.getName())) == null || (bestShadow = this.findBestShadow(s, var)) == null || bestShadow.count < localAssignment.count) continue;
                this.doShadow(localAssignment, bestShadow, var);
                if (ShadowVariablesWithModuleSupport.this.oldPseudoNameMap == null) continue;
                String targetPseudoName = ShadowVariablesWithModuleSupport.this.oldPseudoNameMap.get(((Var)s.getVar((String)bestShadow.oldName)).nameNode);
                for (Reference use : ShadowVariablesWithModuleSupport.this.varToNameUsage.get(var)) {
                    ShadowVariablesWithModuleSupport.this.deltaPseudoNameMap.put(use.nameNode, targetPseudoName);
                }
            }
        }

        public void exitScope(NodeTraversal t) {
        }

        public void visit(NodeTraversal t, Node n, Node parent) {
        }

        private RenameVarsWithModuleSupport.Assignment findBestShadow(Scope curScope, Var var) {
            for (RenameVarsWithModuleSupport.Assignment assignment : ShadowVariablesWithModuleSupport.this.varsByFrequency) {
                if (!assignment.isLocal || ShadowVariablesWithModuleSupport.this.scopeUpRefMap.containsEntry(curScope.getRootNode(), assignment.oldName) || !curScope.hasSlot(assignment.oldName)) continue;
                Var toShadow = (Var)curScope.getVar(assignment.oldName);
                if (var.getScope() == toShadow.getScope()) continue;
                return assignment;
            }
            return null;
        }

        private void doShadow(RenameVarsWithModuleSupport.Assignment original, RenameVarsWithModuleSupport.Assignment toShadow, Var var) {
            Scope s = (Scope)var.getScope();
            Collection<Reference> references = ShadowVariablesWithModuleSupport.this.varToNameUsage.get(var);
            ShadowVariablesWithModuleSupport.this.varsByFrequency.remove(original);
            ShadowVariablesWithModuleSupport.this.varsByFrequency.remove(toShadow);
            original.count -= references.size();
            toShadow.count += references.size();
            ShadowVariablesWithModuleSupport.this.varsByFrequency.add(original);
            ShadowVariablesWithModuleSupport.this.varsByFrequency.add(toShadow);
            Var shadowed = (Var)s.getVar(toShadow.oldName);
            if (shadowed != null) {
                if (s.isFunctionScope() && s.getRootNode().getLastChild().isBlock()) {
                    ShadowVariablesWithModuleSupport.this.scopeUpRefMap.put(s.getRootNode().getLastChild(), toShadow.oldName);
                    ShadowVariablesWithModuleSupport.this.scopeUpRefMap.remove(s.getRootNode().getLastChild(), original.oldName);
                }
                for (Scope curScope = s; curScope != shadowed.scope; curScope = (Scope)curScope.getParent()) {
                    ShadowVariablesWithModuleSupport.this.scopeUpRefMap.put(curScope.getRootNode(), toShadow.oldName);
                    ShadowVariablesWithModuleSupport.this.scopeUpRefMap.remove(curScope.getRootNode(), original.oldName);
                }
            }
            for (Reference ref : references) {
                Node n = ref.nameNode;
                n.setString(toShadow.oldName);
                if (ref.scope.getRootNode() == s.getRootNode()) {
                    if (var.getNameNode() == ref.nameNode) continue;
                    ShadowVariablesWithModuleSupport.this.scopeUpRefMap.put(s.getRootNode(), toShadow.oldName);
                    ShadowVariablesWithModuleSupport.this.scopeUpRefMap.remove(s.getRootNode(), original.oldName);
                    continue;
                }
                Scope curScope = ref.scope;
                while (curScope.getRootNode() != s.getRootNode()) {
                    ShadowVariablesWithModuleSupport.this.scopeUpRefMap.put(curScope.getRootNode(), toShadow.oldName);
                    ShadowVariablesWithModuleSupport.this.scopeUpRefMap.remove(curScope.getRootNode(), original.oldName);
                    curScope = (Scope)curScope.getParent();
                }
            }
        }
    }

    private static final class Reference {
        private final Node nameNode;
        private final Scope scope;

        private Reference(Node nameNode, Scope scope) {
            this.nameNode = nameNode;
            this.scope = scope;
        }
    }
}

