/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import java.util.Objects;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.NoDefinitionScope;
import org.apache.royale.compiler.scopes.IDefinitionSet;

public final class CatchScope
extends NoDefinitionScope {
    private IParameterDefinition parameterDefinition;

    public CatchScope(ASScope containingScope) {
        super(containingScope);
    }

    public void setParameterDefinition(IParameterDefinition param) {
        this.addDefinitionToThisScope(param);
        this.parameterDefinition = param;
    }

    @Override
    public void addDefinition(IDefinition d) {
        if (Objects.equals(d.getBaseName(), this.parameterDefinition.getBaseName())) {
            this.addDefinitionToThisScope(d);
        } else {
            super.addDefinition(d);
        }
    }

    public void displaceParameter(IDefinition d) {
        this.removeDefinition(this.parameterDefinition);
        this.addDefinitionToThisScope(d);
    }

    @Override
    public IDefinitionSet getLocalDefinitionSetByName(String baseName) {
        IDefinitionSet localSet = super.getLocalDefinitionSetByName(baseName);
        IDefinitionSet returnSet = localSet != null && !localSet.isEmpty() ? localSet : this.getContainingScope().getLocalDefinitionSetByName(baseName);
        return returnSet;
    }
}

