////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

package mx.core
{

import org.apache.royale.events.Event;
import org.apache.royale.geom.Point;
import mx.system.ApplicationDomain;
import mx.display.Bitmap;

/**
 *  BitmapAsset is a subclass of the flash.display.Bitmap class
 *  which represents bitmap images that you embed in a Flex application.
 *  It implements the IFlexDisplayObject interface, which makes it
 *  possible for an embedded bitmap image to be displayed in an Image control,
 *  or to be used as a container background or a component skin.
 *
 *  <p>The bitmap image that you're embedding can be in a JPEG, GIF,
 *  or PNG file.
 *  You can also embed a bitmap symbol that is in a SWF file produced
 *  by Flash.
 *  In each of these cases, the MXML compiler autogenerates a class
 *  that extends BitmapAsset to represent the embedded bitmap image.</p>
 *
 *  <p>You don't generally have to use the BitmapAsset class directly
 *  when you write a Flex application.
 *  For example, you can embed a GIF file and display the image
 *  in an Image control by writing the gollowing:</p>
 *
 *  <pre>
 *  &lt;mx:Image id="logo" source="&#64;Embed(source='Logo.gif')"/&gt;</pre>
 *
 *  <p>or use it as the application's background image in CSS syntax
 *  by writing</p>
 *
 *  <pre>
 *  &lt;fx:Style&gt;
 *      &#64;namespace mx "library://ns.apache.org/royale/mx"
 *      mx|Application {
 *          backgroundImage: Embed(source="Logo.gif")
 *      }
 *  &lt;fx:Style/&gt;</pre>
 *
 *  <p>without having to understand that the MXML compiler has created
 *  a subclass of BitmapAsset for you.</p>
 *
 *  <p>However, it may be useful to understand what is happening
 *  at the ActionScript level.
 *  To embed a bitmap image in ActionScript, you declare a variable
 *  of type Class, and put <code>[Embed]</code> metadata on it.
 *  For example, you embed a GIF file like this:</p>
 *
 *  <pre>
 *  [Bindable]
 *  [Embed(source="Logo.gif")]
 *  private var logoClass:Class;</pre>
 *
 *  <p>The MXML compiler sees the .gif extension, transcodes the GIF data
 *  into the bitmap format that the player uses, autogenerates
 *  a subclass of the BitmapAsset class, and sets your variable
 *  to be a reference to this autogenerated class.
 *  You can then use this class reference to create instances of the
 *  BitmapAsset using the <code>new</code> operator, and you can use
 *  APIs of the BitmapAsset class on them:</p>
 *
 *  <pre>
 *  var logo:BitmapAsset = BitmapAsset(new logoClass());
 *  logo.bitmapData.noise(4);</pre>
 *
 *  <p>However, you rarely need to create BitmapAsset instances yourself
 *  because image-related properties and styles can simply be set to an
 *  image-producing class, and components will create image instances
 *  as necessary.
 *  For example, to display this image in an Image control, you can 
 *  set the Image's <code>source</code> property to <code>logoClass</code>.
 *  In MXML you could do this as follows:</p>
 *
 *  <pre>
 *  &lt;mx:Image id="logo" source="{logoClass}"/&gt;</pre>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
public class BitmapAsset extends Bitmap //extends FlexBitmap
                         //implements IFlexAsset, IFlexDisplayObject, ILayoutDirectionElement
{
    //include "../core/Version.as";

    // Softlink FlexVersion and MatrixUtil to remove dependencies of embeds on
    // framework classes. This helps to reduce swf size in AS-only projects.
    private static var FlexVersionClass:Class;
    private static var MatrixUtilClass:Class;
    
    //--------------------------------------------------------------------------
    //
    //  Constructor
    //
    //--------------------------------------------------------------------------

    /**
     *  Constructor.
     *
     *  @param bitmapData The data for the bitmap image. 
     *
     *  @param pixelSnapping Whether or not the bitmap is snapped
     *  to the nearest pixel.
     *
     *  @param smoothing Whether or not the bitmap is smoothed when scaled. 
     *  
     *  @langversion 3.0
     *  @playerversion Flash 9
     *  @playerversion AIR 1.1
     *  @productversion Flex 3
     */
    public function BitmapAsset(bitmapData:Bitmap = null,
                                pixelSnapping:String = "auto",
                                smoothing:Boolean = false)
    {
        super(bitmapData, pixelSnapping, smoothing);
        
     /*   if (FlexVersionClass == null)
        {
            var appDomain:ApplicationDomain = ApplicationDomain.currentDomain;
            if (appDomain.hasDefinition("mx.core::FlexVersion"))
                FlexVersionClass = Class(appDomain.getDefinition("mx.core::FlexVersion"));
        }
        
        if (FlexVersionClass && FlexVersionClass["compatibilityVersion"] >= FlexVersionClass["VERSION_4_0"])
            //this.addEventListener(Event.ADDED, addedHandler); */
    }

}

}
