/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.tools.problems;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class BaseProblemGeneratorMojo
extends AbstractMojo {
    private ImmutableSet<String> nonProblemClassesToFilter = new ImmutableSet.Builder().add((Object)"DefaultSeverity.java").add((Object)"CompositeProblemFilter.java").add((Object)"FilteredIterator.java").add((Object)"CompilerProblemSeverity.java").build();

    protected abstract File getInputDirectory();

    protected abstract File getOutputDirectory();

    protected abstract String getOutputFile();

    protected abstract void clean(File var1) throws MojoExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        File generatedFile = new File(this.getOutputDirectory(), this.getOutputFile());
        if (!generatedFile.getParentFile().exists() && !generatedFile.getParentFile().mkdirs()) {
            throw new MojoExecutionException("Could not create output directory: " + generatedFile.getParentFile());
        }
        this.clean(generatedFile);
        try (PrintWriter writer = new PrintWriter(new FileWriter(generatedFile, true));){
            this.printHeader(writer);
            ArrayList<File> problemClassSourceFiles = new ArrayList<File>(this.getProblemClassSourceFiles(this.getInputDirectory()));
            Collections.sort(problemClassSourceFiles, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    File firstFile = (File)o1;
                    File secondFile = (File)o2;
                    return firstFile.getName().compareTo(secondFile.getName());
                }
            });
            Iterator problemClassSourceFileIterator = problemClassSourceFiles.iterator();
            while (problemClassSourceFileIterator.hasNext()) {
                File problemClassSourceFile = (File)problemClassSourceFileIterator.next();
                this.printEntry(writer, problemClassSourceFile, !problemClassSourceFileIterator.hasNext());
            }
            this.printFooter(writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Caught Exception while trying to create output file: " + generatedFile);
        }
    }

    protected void printHeader(PrintWriter writer) {
    }

    protected abstract void printEntry(PrintWriter var1, File var2, boolean var3);

    protected void printFooter(PrintWriter writer) {
    }

    protected Collection<File> getProblemClassSourceFiles(File dir) {
        Collection problemFiles = FileUtils.listFiles((File)dir, (String[])new String[]{"java"}, (boolean)true);
        return Collections2.filter((Collection)problemFiles, (Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                return BaseProblemGeneratorMojo.this.isProblemClass(input);
            }

            public boolean test(File input) {
                return this.apply(input);
            }
        });
    }

    private boolean isProblemClass(File javaFile) {
        if (this.nonProblemClassesToFilter.contains((Object)javaFile.getName())) {
            return false;
        }
        String javaClassName = FilenameUtils.getBaseName((String)javaFile.getAbsolutePath());
        try {
            List lines = Files.readLines((File)javaFile, (Charset)Charset.forName("UTF8"));
            for (String line : lines) {
                if (line.matches("^\\s*public\\s+final\\s+class\\s+" + javaClassName + "\\s+extends\\s+.*")) {
                    return true;
                }
                if (line.matches("^\\s*final\\s+public\\s+class\\s+" + javaClassName + "\\s+extends\\s+.*")) {
                    return true;
                }
                if (!line.matches("^\\s*public\\s+class\\s+" + javaClassName + "\\s+extends\\s+.*")) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

