/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.bizkeeper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.bizkeeper.FallbackPolicy;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.springframework.stereotype.Component;

@Component
public class FromCacheFallbackPolicy
implements FallbackPolicy {
    private static final String POLICY_NAME = "fromCache";
    private Map<String, Response> cachedResponse = new ConcurrentHashMap<String, Response>();

    @Override
    public String name() {
        return POLICY_NAME;
    }

    @Override
    public Response getFallbackResponse(Invocation invocation, Throwable error) {
        if (this.cachedResponse.get(invocation.getInvocationQualifiedName()) != null) {
            return this.cachedResponse.get(invocation.getInvocationQualifiedName());
        }
        return Response.succResp(null);
    }

    @Override
    public void record(Invocation invocation, Response response, boolean isSuccess) {
        if (isSuccess) {
            this.cachedResponse.put(invocation.getInvocationQualifiedName(), response);
        }
    }
}

