/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.transport.netty.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.ssl.ClientSslSocketFactoryException;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerBuilder;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.loadbalancer.reactive.ExecutionContext;
import com.netflix.loadbalancer.reactive.ExecutionListener;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.netflix.loadbalancer.reactive.ServerOperation;
import com.netflix.ribbon.transport.netty.LoadBalancingRxClientWithPoolOptions;
import com.netflix.ribbon.transport.netty.http.DefaultResponseToErrorPolicy;
import com.netflix.ribbon.transport.netty.http.NettyHttpLoadBalancerErrorHandler;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.HttpMethod;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.PoolLimitDeterminationStrategy;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.contexts.RequestCorrelator;
import io.reactivex.netty.contexts.RequestIdProvider;
import io.reactivex.netty.contexts.RxContexts;
import io.reactivex.netty.contexts.http.HttpRequestIdProvider;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.ssl.DefaultFactories;
import io.reactivex.netty.pipeline.ssl.SSLEngineFactory;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.servo.http.HttpClientListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public class LoadBalancingHttpClient<I, O>
extends LoadBalancingRxClientWithPoolOptions<HttpClientRequest<I>, HttpClientResponse<O>, HttpClient<I, O>>
implements HttpClient<I, O> {
    private static final HttpClient.HttpClientConfig DEFAULT_RX_CONFIG = HttpClient.HttpClientConfig.Builder.newDefaultConfig();
    private final String requestIdHeaderName = this.getProperty(IClientConfigKey.Keys.RequestIdHeaderName, null, null);
    private final HttpRequestIdProvider requestIdProvider = this.requestIdHeaderName != null ? new HttpRequestIdProvider(this.requestIdHeaderName, (RequestCorrelator)RxContexts.DEFAULT_CORRELATOR) : null;
    private final List<ExecutionListener<HttpClientRequest<I>, HttpClientResponse<O>>> listeners;
    private final LoadBalancerCommand<HttpClientResponse<O>> defaultCommandBuilder;
    private final Func2<HttpClientResponse<O>, Integer, Observable<HttpClientResponse<O>>> responseToErrorPolicy;
    private final Func1<Integer, Integer> backoffStrategy;

    public static <I, O> Builder<I, O> builder() {
        return new Builder(new Func1<Builder<I, O>, LoadBalancingHttpClient<I, O>>(){

            public LoadBalancingHttpClient<I, O> call(Builder<I, O> builder) {
                return new LoadBalancingHttpClient(builder);
            }
        });
    }

    protected LoadBalancingHttpClient(Builder<I, O> builder) {
        super(builder.lb, builder.config, (RetryHandler)new RequestSpecificRetryHandler(true, true, builder.retryHandler, null), builder.pipelineConfigurator, builder.poolCleanerScheduler);
        this.listeners = new CopyOnWriteArrayList(builder.listeners);
        this.defaultCommandBuilder = LoadBalancerCommand.builder().withLoadBalancerContext(this.lbContext).withListeners(this.listeners).withClientConfig(builder.config).withRetryHandler(builder.retryHandler).build();
        this.responseToErrorPolicy = builder.responseToErrorPolicy;
        this.backoffStrategy = builder.backoffStrategy;
    }

    private RetryHandler getRequestRetryHandler(HttpClientRequest<?> request, IClientConfig requestConfig) {
        return new RequestSpecificRetryHandler(true, request.getMethod().equals((Object)HttpMethod.GET), this.defaultRetryHandler, requestConfig);
    }

    protected static void setHostHeader(HttpClientRequest<?> request, String host) {
        request.getHeaders().set("Host", (Object)host);
    }

    public Observable<HttpClientResponse<O>> submit(HttpClientRequest<I> request) {
        return this.submit(request, null, null);
    }

    public Observable<HttpClientResponse<O>> submit(HttpClientRequest<I> request, RxClient.ClientConfig config) {
        return this.submit(null, request, null, null, config);
    }

    public Observable<HttpClientResponse<O>> submit(Server server, HttpClientRequest<I> request, IClientConfig requestConfig) {
        return this.submit(server, request, null, requestConfig, this.getRxClientConfig(requestConfig));
    }

    public Observable<HttpClientResponse<O>> submit(HttpClientRequest<I> request, RetryHandler errorHandler, IClientConfig requestConfig) {
        return this.submit(null, request, errorHandler, requestConfig, null);
    }

    public Observable<HttpClientResponse<O>> submit(Server server, HttpClientRequest<I> request) {
        return this.submit(server, request, null, null, this.getRxClientConfig(null));
    }

    protected ServerOperation<HttpClientResponse<O>> requestToOperation(final HttpClientRequest<I> request, final RxClient.ClientConfig rxClientConfig) {
        Preconditions.checkNotNull(request);
        return new ServerOperation<HttpClientResponse<O>>(){
            final AtomicInteger count = new AtomicInteger(0);

            public Observable<HttpClientResponse<O>> call(Server server) {
                HttpClient rxClient = (HttpClient)LoadBalancingHttpClient.this.getOrCreateRxClient(server);
                LoadBalancingHttpClient.setHostHeader(request, server.getHost());
                Observable o = rxClientConfig != null ? rxClient.submit(request, rxClientConfig) : rxClient.submit(request);
                return o.concatMap(new Func1<HttpClientResponse<O>, Observable<HttpClientResponse<O>>>(){

                    public Observable<HttpClientResponse<O>> call(HttpClientResponse<O> t1) {
                        if (t1.getStatus().code() / 100 == 4 || t1.getStatus().code() / 100 == 5) {
                            return (Observable)LoadBalancingHttpClient.this.responseToErrorPolicy.call(t1, LoadBalancingHttpClient.this.backoffStrategy.call((Object)count.getAndIncrement()));
                        }
                        return Observable.just(t1);
                    }
                });
            }
        };
    }

    private RxClient.ClientConfig getRxClientConfig(IClientConfig requestConfig) {
        if (requestConfig == null) {
            return DEFAULT_RX_CONFIG;
        }
        int requestReadTimeout = this.getProperty(IClientConfigKey.Keys.ReadTimeout, requestConfig, 5000);
        Boolean followRedirect = this.getProperty(IClientConfigKey.Keys.FollowRedirects, requestConfig, null);
        HttpClient.HttpClientConfig.Builder builder = (HttpClient.HttpClientConfig.Builder)new HttpClient.HttpClientConfig.Builder().readTimeout(requestReadTimeout, TimeUnit.MILLISECONDS);
        if (followRedirect != null) {
            builder.setFollowRedirect(followRedirect.booleanValue());
        }
        return builder.build();
    }

    private RxClient.ClientConfig getRxClientConfig(IClientConfig ribbonClientConfig, RxClient.ClientConfig rxClientConfig) {
        if (ribbonClientConfig == null) {
            return rxClientConfig;
        }
        if (rxClientConfig == null) {
            return this.getRxClientConfig(ribbonClientConfig);
        }
        int readTimeoutFormRibbon = (Integer)ribbonClientConfig.get(CommonClientConfigKey.ReadTimeout, (Object)-1);
        if (rxClientConfig instanceof HttpClient.HttpClientConfig) {
            HttpClient.HttpClientConfig httpConfig = (HttpClient.HttpClientConfig)rxClientConfig;
            HttpClient.HttpClientConfig.Builder builder = HttpClient.HttpClientConfig.Builder.from((HttpClient.HttpClientConfig)httpConfig);
            if (readTimeoutFormRibbon >= 0) {
                builder.readTimeout(readTimeoutFormRibbon, TimeUnit.MILLISECONDS);
            }
            return builder.build();
        }
        RxClient.ClientConfig.Builder builder = new RxClient.ClientConfig.Builder(rxClientConfig);
        if (readTimeoutFormRibbon >= 0) {
            builder.readTimeout(readTimeoutFormRibbon, TimeUnit.MILLISECONDS);
        }
        return builder.build();
    }

    private IClientConfig getRibbonClientConfig(RxClient.ClientConfig rxClientConfig) {
        if (rxClientConfig != null && rxClientConfig.isReadTimeoutSet()) {
            return IClientConfig.Builder.newBuilder().withReadTimeout((int)rxClientConfig.getReadTimeoutInMillis()).build();
        }
        return null;
    }

    private Observable<HttpClientResponse<O>> submit(Server server, HttpClientRequest<I> request, RetryHandler errorHandler, IClientConfig requestConfig, RxClient.ClientConfig rxClientConfig) {
        ExecutionContext context;
        DefaultClientConfigImpl config;
        Observable result;
        RetryHandler retryHandler = errorHandler;
        if (retryHandler == null) {
            retryHandler = this.getRequestRetryHandler(request, requestConfig);
        }
        if ((result = this.submitToServerInURI(request, (IClientConfig)(config = requestConfig == null ? DefaultClientConfigImpl.getEmptyConfig() : requestConfig), rxClientConfig, retryHandler, context = new ExecutionContext(request, (IClientConfig)config, this.getClientConfig(), retryHandler))) == null) {
            LoadBalancerCommand command = retryHandler != this.defaultRetryHandler ? LoadBalancerCommand.builder().withExecutionContext(context).withLoadBalancerContext(this.lbContext).withListeners(this.listeners).withClientConfig(this.getClientConfig()).withRetryHandler(retryHandler).withServer(server).build() : this.defaultCommandBuilder;
            result = command.submit(this.requestToOperation(request, this.getRxClientConfig((IClientConfig)config, rxClientConfig)));
        }
        return result;
    }

    @VisibleForTesting
    ServerStats getServerStats(Server server) {
        return this.lbContext.getServerStats(server);
    }

    private Observable<HttpClientResponse<O>> submitToServerInURI(HttpClientRequest<I> request, IClientConfig requestConfig, RxClient.ClientConfig config, RetryHandler errorHandler, ExecutionContext<HttpClientRequest<I>> context) {
        URI uri;
        try {
            uri = new URI(request.getUri());
        }
        catch (URISyntaxException e) {
            return Observable.error((Throwable)e);
        }
        String host = uri.getHost();
        if (host == null) {
            return null;
        }
        int port = uri.getPort();
        if (port < 0) {
            port = this.clientConfig.getPropertyAsBoolean(IClientConfigKey.Keys.IsSecure, false) ? 443 : 80;
        }
        return LoadBalancerCommand.builder().withRetryHandler(errorHandler).withLoadBalancerContext(this.lbContext).withListeners(this.listeners).withExecutionContext(context).withServer(new Server(host, port)).build().submit(this.requestToOperation(request, this.getRxClientConfig(requestConfig, config)));
    }

    @Override
    protected HttpClient<I, O> createRxClient(Server server) {
        HttpClientBuilder clientBuilder = this.requestIdProvider != null ? RxContexts.newHttpClientBuilder((String)server.getHost(), (int)server.getPort(), (RequestIdProvider)this.requestIdProvider, (RequestCorrelator)RxContexts.DEFAULT_CORRELATOR, (PipelineConfigurator)this.pipelineConfigurator) : RxContexts.newHttpClientBuilder((String)server.getHost(), (int)server.getPort(), (RequestCorrelator)RxContexts.DEFAULT_CORRELATOR, (PipelineConfigurator)this.pipelineConfigurator);
        Integer connectTimeout = this.getProperty(IClientConfigKey.Keys.ConnectTimeout, null, 2000);
        Integer readTimeout = this.getProperty(IClientConfigKey.Keys.ReadTimeout, null, 5000);
        Boolean followRedirect = this.getProperty(IClientConfigKey.Keys.FollowRedirects, null, null);
        HttpClient.HttpClientConfig.Builder builder = (HttpClient.HttpClientConfig.Builder)new HttpClient.HttpClientConfig.Builder().readTimeout(readTimeout.intValue(), TimeUnit.MILLISECONDS);
        if (followRedirect != null) {
            builder.setFollowRedirect(followRedirect.booleanValue());
        }
        ((HttpClientBuilder)clientBuilder.channelOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout)).config(builder.build());
        if (this.isPoolEnabled()) {
            ((HttpClientBuilder)((HttpClientBuilder)clientBuilder.withConnectionPoolLimitStrategy((PoolLimitDeterminationStrategy)this.poolStrategy)).withIdleConnectionsTimeoutMillis((long)this.idleConnectionEvictionMills)).withPoolIdleCleanupScheduler(this.poolCleanerScheduler);
        } else {
            clientBuilder.withNoConnectionPooling();
        }
        if (this.sslContextFactory != null) {
            try {
                DefaultFactories.SSLContextBasedFactory myFactory = new DefaultFactories.SSLContextBasedFactory(this.sslContextFactory.getSSLContext()){

                    public SSLEngine createSSLEngine(ByteBufAllocator allocator) {
                        SSLEngine myEngine = super.createSSLEngine(allocator);
                        myEngine.setUseClientMode(true);
                        return myEngine;
                    }
                };
                clientBuilder.withSslEngineFactory((SSLEngineFactory)myFactory);
            }
            catch (ClientSslSocketFactoryException e) {
                throw new RuntimeException(e);
            }
        }
        return (HttpClient)clientBuilder.build();
    }

    @VisibleForTesting
    HttpClientListener getListener() {
        return (HttpClientListener)this.listener;
    }

    @VisibleForTesting
    Map<Server, HttpClient<I, O>> getRxClients() {
        return this.rxClientCache;
    }

    @Override
    protected MetricEventsListener<? extends ClientMetricsEvent<?>> createListener(String name) {
        return HttpClientListener.newHttpListener((String)name);
    }

    public static class Builder<I, O> {
        ILoadBalancer lb;
        IClientConfig config;
        RetryHandler retryHandler;
        PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator;
        ScheduledExecutorService poolCleanerScheduler;
        List<ExecutionListener<HttpClientRequest<I>, HttpClientResponse<O>>> listeners;
        Func2<HttpClientResponse<O>, Integer, Observable<HttpClientResponse<O>>> responseToErrorPolicy;
        Func1<Integer, Integer> backoffStrategy;
        Func1<Builder<I, O>, LoadBalancingHttpClient<I, O>> build;

        protected Builder(Func1<Builder<I, O>, LoadBalancingHttpClient<I, O>> build) {
            this.build = build;
        }

        public Builder<I, O> withLoadBalancer(ILoadBalancer lb) {
            this.lb = lb;
            return this;
        }

        public Builder<I, O> withClientConfig(IClientConfig config) {
            this.config = config;
            return this;
        }

        public Builder<I, O> withRetryHandler(RetryHandler retryHandler) {
            this.retryHandler = retryHandler;
            return this;
        }

        public Builder<I, O> withPipelineConfigurator(PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator) {
            this.pipelineConfigurator = pipelineConfigurator;
            return this;
        }

        public Builder<I, O> withPoolCleanerScheduler(ScheduledExecutorService poolCleanerScheduler) {
            this.poolCleanerScheduler = poolCleanerScheduler;
            return this;
        }

        public Builder<I, O> withExecutorListeners(List<ExecutionListener<HttpClientRequest<I>, HttpClientResponse<O>>> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder<I, O> withResponseToErrorPolicy(Func2<HttpClientResponse<O>, Integer, Observable<HttpClientResponse<O>>> responseToErrorPolicy) {
            this.responseToErrorPolicy = responseToErrorPolicy;
            return this;
        }

        public Builder<I, O> withBackoffStrategy(Func1<Integer, Integer> backoffStrategy) {
            this.backoffStrategy = backoffStrategy;
            return this;
        }

        public LoadBalancingHttpClient<I, O> build() {
            if (this.retryHandler == null) {
                this.retryHandler = new NettyHttpLoadBalancerErrorHandler();
            }
            if (this.config == null) {
                this.config = DefaultClientConfigImpl.getClientConfigWithDefaultValues();
            }
            if (this.lb == null) {
                this.lb = LoadBalancerBuilder.newBuilder().withClientConfig(this.config).buildLoadBalancerFromConfigWithReflection();
            }
            if (this.listeners == null) {
                this.listeners = Collections.emptyList();
            }
            if (this.backoffStrategy == null) {
                this.backoffStrategy = new Func1<Integer, Integer>(){

                    public Integer call(Integer backoffCount) {
                        int interval = Builder.this.config.getPropertyAsInteger(IClientConfigKey.Keys.BackoffInterval, 0);
                        if (backoffCount < 0) {
                            backoffCount = 0;
                        } else if (backoffCount > 10) {
                            backoffCount = 10;
                        }
                        return (int)Math.pow(2.0, backoffCount.intValue()) * interval;
                    }
                };
            }
            if (this.responseToErrorPolicy == null) {
                this.responseToErrorPolicy = new DefaultResponseToErrorPolicy();
            }
            return (LoadBalancingHttpClient)this.build.call((Object)this);
        }
    }
}

