/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec;

import java.nio.ByteBuffer;
import reactor.core.support.Assert;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.BufferCodec;
import reactor.io.codec.Codec;

public class LengthFieldCodec<IN, OUT>
extends BufferCodec<IN, OUT> {
    private final int lengthFieldLength;
    private final Codec<Buffer, IN, OUT> delegate;

    public LengthFieldCodec(Codec<Buffer, IN, OUT> delegate) {
        this(4, delegate);
    }

    public LengthFieldCodec(int lengthFieldLength, Codec<Buffer, IN, OUT> delegate) {
        Assert.state(lengthFieldLength == 2 || lengthFieldLength == 4 || lengthFieldLength == 8, "lengthFieldLength should be 2 (short), 4 (int), or 8 (long).");
        this.lengthFieldLength = lengthFieldLength;
        this.delegate = delegate;
    }

    @Override
    public Function<Buffer, IN> decoder(Consumer<IN> next) {
        return new LengthFieldDecoder(next);
    }

    @Override
    public Buffer apply(OUT out) {
        if (null == out) {
            return null;
        }
        Buffer encoded = (Buffer)this.delegate.apply(out);
        if (null != encoded && encoded.remaining() > 0) {
            int len = encoded.remaining();
            ByteBuffer bb = null;
            if (this.lengthFieldLength == 4) {
                bb = ByteBuffer.allocate(len + 4);
                bb.putInt(len);
            } else if (this.lengthFieldLength == 2) {
                bb = ByteBuffer.allocate(len + 2);
                bb.putShort((short)len);
            } else if (this.lengthFieldLength == 8) {
                bb = ByteBuffer.allocate(len + 8);
                bb.putLong(len);
            }
            if (null != bb) {
                bb.put(encoded.byteBuffer()).flip();
                return new Buffer(bb);
            }
        }
        return encoded;
    }

    private class LengthFieldDecoder
    implements Function<Buffer, IN> {
        private final Function<Buffer, IN> decoder;

        private LengthFieldDecoder(Consumer<IN> next) {
            this.decoder = LengthFieldCodec.this.delegate.decoder(next);
        }

        @Override
        public IN apply(Buffer buffer) {
            while (buffer.remaining() > LengthFieldCodec.this.lengthFieldLength) {
                int expectedLen = this.readLen(buffer);
                if (expectedLen < 0 || expectedLen > buffer.remaining()) {
                    buffer.rewind(LengthFieldCodec.this.lengthFieldLength);
                    return null;
                }
                int pos = buffer.position();
                int limit = buffer.limit();
                Buffer.View v = buffer.createView(pos, pos + expectedLen);
                Object in = this.decoder.apply(v.get());
                buffer.byteBuffer().limit(limit);
                if (buffer.position() == pos) {
                    buffer.skip(expectedLen);
                }
                if (null == in) continue;
                return in;
            }
            return null;
        }

        private int readLen(Buffer buffer) {
            if (LengthFieldCodec.this.lengthFieldLength == 4) {
                return buffer.readInt();
            }
            if (LengthFieldCodec.this.lengthFieldLength == 2) {
                return buffer.readShort();
            }
            return (int)buffer.readLong();
        }
    }
}

