/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class Reflection {
    private Reflection() {
    }

    public static Set<Field> getAllFields(Class<?> classs) {
        HashSet<Field> set = new HashSet<Field>();
        for (Class<?> c = classs; c != null; c = c.getSuperclass()) {
            set.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return set;
    }

    public static Set<Method> getAllMethods(Class<?> classs) {
        HashSet<Method> set = new HashSet<Method>();
        for (Class<?> c = classs; c != null; c = c.getSuperclass()) {
            set.addAll(Arrays.asList(c.getDeclaredMethods()));
        }
        return set;
    }

    public static Set<Field> getFieldsAnnotatedBy(Class<?> classs, Class<? extends Annotation> ann) {
        HashSet<Field> set = new HashSet<Field>();
        for (Field field : Reflection.getAllFields(classs)) {
            if (!field.isAnnotationPresent(ann)) continue;
            set.add(field);
        }
        return set;
    }

    public static Set<Method> getMethodsAnnotatedBy(Class<?> classs, Class<? extends Annotation> ann) {
        HashSet<Method> set = new HashSet<Method>();
        for (Method method : Reflection.getAllMethods(classs)) {
            if (!method.isAnnotationPresent(ann)) continue;
            set.add(method);
        }
        return set;
    }
}

