/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.servo;

import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServoUtils {
    private static final Logger logger = LoggerFactory.getLogger(ServoUtils.class);

    private ServoUtils() {
    }

    public static <T> T registerObject(String id, T objectToRegister) {
        try {
            Monitors.registerObject((String)id, objectToRegister);
        }
        catch (Exception e) {
            logger.error("Failed to register object with the servo registry.", (Throwable)e);
        }
        return objectToRegister;
    }

    public static void unregisterObject(String id, Object objectToRegister) {
        try {
            Monitors.unregisterObject((String)id, (Object)objectToRegister);
        }
        catch (Exception e) {
            logger.error("Failed to unregister object with the servo registry.", (Throwable)e);
        }
    }

    public static LongGauge newLongGauge(String name) {
        return new LongGauge(MonitorConfig.builder((String)name).build());
    }

    public static long incrementLongGauge(LongGauge gauge) {
        return gauge.getNumber().incrementAndGet();
    }

    public static long decrementLongGauge(LongGauge gauge) {
        return gauge.getNumber().decrementAndGet();
    }
}

