/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route.support;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;
import org.springframework.cloud.netflix.zuul.filters.route.ZuulFallbackProvider;

public abstract class AbstractRibbonCommandFactory
implements RibbonCommandFactory {
    private Map<String, ZuulFallbackProvider> fallbackProviderCache = new HashMap<String, ZuulFallbackProvider>();
    private ZuulFallbackProvider defaultFallbackProvider = null;

    public AbstractRibbonCommandFactory(Set<ZuulFallbackProvider> fallbackProviders) {
        for (ZuulFallbackProvider provider : fallbackProviders) {
            String route = provider.getRoute();
            if ("*".equals(route) || route == null) {
                this.defaultFallbackProvider = provider;
                continue;
            }
            this.fallbackProviderCache.put(route, provider);
        }
    }

    protected ZuulFallbackProvider getFallbackProvider(String route) {
        ZuulFallbackProvider provider = this.fallbackProviderCache.get(route);
        if (provider == null) {
            provider = this.defaultFallbackProvider;
        }
        return provider;
    }
}

