/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.cloud.client.ServiceInstance;

public class DefaultServiceInstance
implements ServiceInstance {
    private final String serviceId;
    private final String host;
    private final int port;
    private final boolean secure;
    private final Map<String, String> metadata;

    public DefaultServiceInstance(String serviceId, String host, int port, boolean secure, Map<String, String> metadata) {
        this.serviceId = serviceId;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.metadata = metadata;
    }

    public DefaultServiceInstance(String serviceId, String host, int port, boolean secure) {
        this(serviceId, host, port, secure, new LinkedHashMap<String, String>());
    }

    @Override
    public URI getUri() {
        return DefaultServiceInstance.getUri(this);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static URI getUri(ServiceInstance instance) {
        String scheme = instance.isSecure() ? "https" : "http";
        String uri = String.format("%s://%s:%s", scheme, instance.getHost(), instance.getPort());
        return URI.create(uri);
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        return "DefaultServiceInstance{serviceId='" + this.serviceId + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", secure=" + this.secure + ", metadata=" + this.metadata + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultServiceInstance that = (DefaultServiceInstance)o;
        return this.port == that.port && this.secure == that.secure && Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.host, that.host) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.host, this.port, this.secure, this.metadata);
    }
}

