/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc.processor.annotation;

import io.swagger.models.Swagger;
import java.lang.reflect.Type;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestMappingClassAnnotationProcessor
implements ClassAnnotationProcessor<RequestMapping> {
    public Type getProcessType() {
        return RequestMapping.class;
    }

    public void process(SwaggerGenerator swaggerGenerator, RequestMapping requestMapping) {
        Swagger swagger = swaggerGenerator.getSwagger();
        this.processMethod(requestMapping.method(), swaggerGenerator);
        this.processPath(requestMapping.path(), swaggerGenerator);
        this.processPath(requestMapping.value(), swaggerGenerator);
        SwaggerUtils.setConsumes((Swagger)swagger, (String[])requestMapping.consumes());
        SwaggerUtils.setProduces((Swagger)swagger, (String[])requestMapping.produces());
    }

    protected void processPath(String[] paths, SwaggerGenerator swaggerGenerator) {
        if (null == paths || paths.length == 0) {
            return;
        }
        if (paths.length > 1) {
            throw new IllegalStateException(String.format("not support multi path, class=%s.", swaggerGenerator.getClazz().getName()));
        }
        swaggerGenerator.setBasePath(paths[0]);
    }

    protected void processMethod(RequestMethod[] requestMethods, SwaggerGenerator swaggerGenerator) {
        if (null == requestMethods || requestMethods.length == 0) {
            return;
        }
        if (requestMethods.length > 1) {
            throw new IllegalStateException(String.format("not support multi http method, class=%s.", swaggerGenerator.getClazz().getName()));
        }
        swaggerGenerator.setHttpMethod(requestMethods[0].name());
    }
}

