/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;

public class SystemMetrics {
    private final OperatingSystemMXBean systemMXBean;
    private final ThreadMXBean threadMXBean;
    private final MemoryMXBean memoryMXBean;

    public SystemMetrics() {
        this(ManagementFactory.getOperatingSystemMXBean(), ManagementFactory.getThreadMXBean(), ManagementFactory.getMemoryMXBean());
    }

    public SystemMetrics(OperatingSystemMXBean systemMXBean, ThreadMXBean threadMXBean, MemoryMXBean memoryMXBean) {
        this.systemMXBean = systemMXBean;
        this.threadMXBean = threadMXBean;
        this.memoryMXBean = memoryMXBean;
    }

    public double getCpuLoad() {
        return this.systemMXBean.getSystemLoadAverage();
    }

    public int getCpuRunningThreads() {
        return this.threadMXBean.getThreadCount();
    }

    public long getHeapInit() {
        return this.memoryMXBean.getHeapMemoryUsage().getInit();
    }

    public long getHeapMax() {
        return this.memoryMXBean.getHeapMemoryUsage().getMax();
    }

    public long getHeapCommit() {
        return this.memoryMXBean.getHeapMemoryUsage().getCommitted();
    }

    public long getHeapUsed() {
        return this.memoryMXBean.getHeapMemoryUsage().getUsed();
    }

    public long getNonHeapInit() {
        return this.memoryMXBean.getNonHeapMemoryUsage().getInit();
    }

    public long getNonHeapMax() {
        return this.memoryMXBean.getNonHeapMemoryUsage().getMax();
    }

    public long getNonHeapCommit() {
        return this.memoryMXBean.getNonHeapMemoryUsage().getCommitted();
    }

    public long getNonHeapUsed() {
        return this.memoryMXBean.getNonHeapMemoryUsage().getUsed();
    }
}

