/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os.net;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.metrics.core.meter.os.NetMeter;
import org.apache.servicecomb.metrics.core.meter.os.net.NetStat;

public class InterfaceUsage {
    private final String name;
    private final List<NetStat> netStats = new ArrayList<NetStat>();

    public InterfaceUsage(Id id, String name) {
        this.name = name;
        id = id.withTag("interface", name);
        this.init(id);
    }

    private void init(Id id) {
        this.netStats.add(new NetStat(id.withTag(NetMeter.TAG_RECEIVE), 0));
        this.netStats.add(new NetStat(id.withTag(NetMeter.TAG_SEND), 8));
        this.netStats.add(new NetStat(id.withTag(NetMeter.TAG_PACKETS_RECEIVE), 1));
        this.netStats.add(new NetStat(id.withTag(NetMeter.TAG_PACKETS_SEND), 9));
    }

    public void calcMeasurements(List<Measurement> measurements, long msNow) {
        this.netStats.forEach(netStat -> measurements.add(new Measurement(netStat.getId(), msNow, netStat.getRate())));
    }

    public void update(String interfaceData, long secondInterval) {
        String[] netInfo = interfaceData.trim().split("\\s+");
        this.netStats.forEach(netStat -> netStat.update(netInfo, secondInterval));
    }

    public String getName() {
        return this.name;
    }

    public List<NetStat> getNetStats() {
        return this.netStats;
    }
}

