/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.faultinjection;

import io.vertx.core.Vertx;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.faultinjection.AbstractFault;
import org.apache.servicecomb.faultinjection.FaultInjectionUtil;
import org.apache.servicecomb.faultinjection.FaultParam;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayFault
extends AbstractFault {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayFault.class);

    @Override
    public int getOrder() {
        return 100;
    }

    @Override
    public void injectFault(Invocation invocation, FaultParam faultParam, AsyncResponse asynResponse) {
        if (!this.shouldDelay(invocation, faultParam, asynResponse)) {
            asynResponse.success((Object)"success");
            return;
        }
        LOGGER.debug("Fault injection: delay is added for the request by fault inject handler");
        long delay = FaultInjectionUtil.getFaultInjectionConfig(invocation, "delay.fixedDelay");
        if (delay == -1L) {
            LOGGER.debug("Fault injection: delay is not configured");
            asynResponse.success((Object)"success");
            return;
        }
        this.executeDelay(faultParam, asynResponse, delay);
    }

    private void executeDelay(FaultParam faultParam, AsyncResponse asynResponse, long delay) {
        Vertx vertx = faultParam.getVertx();
        if (vertx != null) {
            vertx.setTimer(delay, timeID -> asynResponse.success((Object)"success"));
            return;
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            LOGGER.info("Interrupted exception is received");
        }
        asynResponse.success((Object)"success");
    }

    private boolean shouldDelay(Invocation invocation, FaultParam faultParam, AsyncResponse asynResponse) {
        int delayPercent = FaultInjectionUtil.getFaultInjectionConfig(invocation, "delay.percent");
        if (delayPercent == -1) {
            LOGGER.debug("Fault injection: delay percentage is not configured");
            return false;
        }
        return FaultInjectionUtil.isFaultNeedToInject(faultParam.getReqCount(), delayPercent);
    }
}

