/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider;

import io.swagger.v3.oas.models.OpenAPI;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.servicecomb.core.provider.OpenAPIRegistry;
import org.apache.servicecomb.foundation.common.utils.ResourceUtil;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class OpenAPIRegistryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIRegistryManager.class);
    private List<OpenAPIRegistry> openAPIRegistries;
    private final List<OpenAPIChangeListener> changeListeners = new ArrayList<OpenAPIChangeListener>();

    @Autowired
    public void setOpenAPIRegistries(List<OpenAPIRegistry> openAPIRegistries) {
        ArrayList<OpenAPIRegistry> target = new ArrayList<OpenAPIRegistry>(openAPIRegistries.size());
        for (OpenAPIRegistry registry : openAPIRegistries) {
            if (!registry.enabled()) continue;
            registry.setOpenAPIChangeListener(this::onOpenAPIChanged);
            target.add(registry);
        }
        this.openAPIRegistries = target;
    }

    public void addOpenAPIChangeListener(OpenAPIChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void onOpenAPIChanged(String application, String serviceName) {
        for (OpenAPIChangeListener listener : this.changeListeners) {
            try {
                listener.onOpenAPIChanged(application, serviceName);
            }
            catch (Exception e) {
                LOGGER.warn("event process error {}/{}, {}", new Object[]{application, serviceName, e.getMessage()});
            }
        }
    }

    public void registerOpenAPI(String application, String serviceName, String schemaId, OpenAPI api) {
        for (OpenAPIRegistry registry : this.openAPIRegistries) {
            registry.registerOpenAPI(application, serviceName, schemaId, api);
        }
    }

    public void registerOpenAPI(String application, String serviceName, String schemaId, Class<?> cls) {
        OpenAPI api = SwaggerGenerator.generate(cls);
        this.registerOpenAPI(application, serviceName, schemaId, api);
    }

    public void registerOpenAPIInLocation(String application, String serviceName, String swaggersLocation) {
        try {
            List resourceUris = ResourceUtil.findResourcesBySuffix((String)swaggersLocation, (String)".yaml");
            if (resourceUris.isEmpty()) {
                return;
            }
            for (URI uri : resourceUris) {
                URL url = uri.toURL();
                OpenAPI swagger = SwaggerUtils.parseAndValidateSwagger((URL)url);
                String schemaId = FilenameUtils.getBaseName((String)url.getPath());
                this.registerOpenAPI(application, serviceName, schemaId, swagger);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(String.format("failed to register swaggers, microserviceName=%s, location=%s.", serviceName, swaggersLocation), e);
        }
    }

    public Map<String, OpenAPI> loadOpenAPI(String appId, String microserviceName) {
        for (OpenAPIRegistry registry : this.openAPIRegistries) {
            Map<String, OpenAPI> result = registry.loadOpenAPI(appId, microserviceName);
            if (CollectionUtils.isEmpty(result)) continue;
            return result;
        }
        return Collections.emptyMap();
    }

    public static interface OpenAPIChangeListener {
        public void onOpenAPIChanged(String var1, String var2);
    }
}

