/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.provider;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public class PathCheckUtils {
    private static final String KEY_INCLUDE_PATH = "servicecomb.publicKey.accessControl.includePathPatterns";
    private static final String KEY_EXCLUDE_PATH = "servicecomb.publicKey.accessControl.excludePathPatterns";

    public static boolean isNotRequiredAuth(String requestPath, Environment env) {
        if (PathCheckUtils.excludePathMatchPath(requestPath, env)) {
            return true;
        }
        return PathCheckUtils.includePathMatchPath(requestPath, env);
    }

    private static boolean excludePathMatchPath(String requestPath, Environment env) {
        String excludePathPattern = env.getProperty(KEY_EXCLUDE_PATH, "");
        if (StringUtils.isEmpty((CharSequence)excludePathPattern)) {
            return false;
        }
        return PathCheckUtils.isPathMather(requestPath, excludePathPattern);
    }

    private static boolean includePathMatchPath(String requestPath, Environment env) {
        String includePathPattern = env.getProperty(KEY_INCLUDE_PATH, "");
        if (StringUtils.isEmpty((CharSequence)includePathPattern)) {
            return false;
        }
        return !PathCheckUtils.isPathMather(requestPath, includePathPattern);
    }

    private static boolean isPathMather(String requestPath, String pathPattern) {
        for (String pattern : pathPattern.split(",")) {
            if (pattern.isEmpty() || !PathCheckUtils.isPatternMatch(requestPath, pattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPatternMatch(String value, String pattern) {
        if (pattern.startsWith("*") || pattern.startsWith("/*")) {
            int index = 0;
            for (int i = 0; i < pattern.length() && (pattern.charAt(i) == '*' || pattern.charAt(i) == '/'); ++i) {
                ++index;
            }
            return value.endsWith(pattern.substring(index));
        }
        if (pattern.endsWith("*")) {
            int index = pattern.length() - 1;
            for (int i = pattern.length() - 1; i >= 0 && (pattern.charAt(i) == '*' || pattern.charAt(i) == '/'); --i) {
                --index;
            }
            return value.startsWith(pattern.substring(0, index + 1));
        }
        return value.equals(pattern);
    }
}

