/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.ignore;

import com.google.common.collect.ImmutableList;
import io.swagger.codegen.ignore.rules.DirectoryRule;
import io.swagger.codegen.ignore.rules.Rule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodegenIgnoreProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodegenIgnoreProcessor.class);
    private File ignoreFile = null;
    private List<Rule> exclusionRules = new ArrayList<Rule>();
    private List<Rule> inclusionRules = new ArrayList<Rule>();

    public CodegenIgnoreProcessor(String baseDirectory) {
        this(baseDirectory, ".swagger-codegen-ignore");
    }

    public CodegenIgnoreProcessor(String baseDirectory, String ignoreFile) {
        File directory = new File(baseDirectory);
        File targetIgnoreFile = new File(directory, ignoreFile);
        if (directory.exists() && directory.isDirectory()) {
            this.loadFromFile(targetIgnoreFile);
        } else {
            LOGGER.warn("Output directory does not exist, or is inaccessible. No file (.swagger-codegen-ignore) will be evaluated.");
        }
    }

    public CodegenIgnoreProcessor(File targetIgnoreFile) {
        this.loadFromFile(targetIgnoreFile);
    }

    private void loadFromFile(File targetIgnoreFile) {
        if (targetIgnoreFile.exists() && targetIgnoreFile.isFile()) {
            try {
                this.loadCodegenRules(targetIgnoreFile);
                this.ignoreFile = targetIgnoreFile;
            }
            catch (IOException e) {
                LOGGER.error(String.format("Could not process %s.", targetIgnoreFile.getName()), (Object)e.getMessage());
            }
        } else {
            LOGGER.info(String.format("No %s file found.", targetIgnoreFile.getName()));
        }
    }

    void loadCodegenRules(File codegenIgnore) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(codegenIgnore));){
            String line;
            while ((line = reader.readLine()) != null) {
                Rule rule;
                if (line.length() == 0 || (rule = Rule.create(line)) == null) continue;
                if (Boolean.TRUE.equals(rule.getNegated())) {
                    this.inclusionRules.add(rule);
                    continue;
                }
                this.exclusionRules.add(rule);
            }
        }
    }

    public boolean allowsFile(File targetFile) {
        Rule.Operation op;
        Rule current;
        int i;
        if (this.ignoreFile == null) {
            return true;
        }
        File file = new File(this.ignoreFile.getParentFile().toURI().relativize(targetFile.toURI()).getPath());
        Boolean directoryExcluded = false;
        Boolean exclude = false;
        if (this.exclusionRules.size() == 0 && this.inclusionRules.size() == 0) {
            return true;
        }
        block6: for (i = 0; i < this.exclusionRules.size(); ++i) {
            current = this.exclusionRules.get(i);
            op = current.evaluate(file.getPath());
            switch (op) {
                case EXCLUDE: {
                    exclude = true;
                    if (!(current instanceof DirectoryRule)) continue block6;
                    directoryExcluded = true;
                    continue block6;
                }
                case INCLUDE: {
                    continue block6;
                }
                case NOOP: {
                    continue block6;
                }
                case EXCLUDE_AND_TERMINATE: {
                    i = this.exclusionRules.size();
                }
            }
        }
        if (exclude.booleanValue()) {
            for (i = 0; exclude.booleanValue() && i < this.inclusionRules.size(); ++i) {
                current = this.inclusionRules.get(i);
                op = current.evaluate(file.getPath());
                if (!op.equals((Object)Rule.Operation.INCLUDE)) continue;
                if (current instanceof DirectoryRule && directoryExcluded.booleanValue()) {
                    exclude = false;
                    continue;
                }
                if (directoryExcluded.booleanValue()) continue;
                exclude = false;
            }
        }
        return Boolean.FALSE.equals(exclude);
    }

    public List<Rule> getInclusionRules() {
        return ImmutableList.copyOf(this.inclusionRules);
    }

    public List<Rule> getExclusionRules() {
        return ImmutableList.copyOf(this.exclusionRules);
    }
}

