/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.validation.api;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasObjectValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;

public abstract class ObjectPropertyRequiredValidator<T, P>
implements OasObjectValidator<T> {
    @Override
    public final List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, T oasObject) {
        if (StringUtils.isNotBlank((CharSequence)this.get$ref(oasObject))) {
            return Collections.emptyList();
        }
        P propertyObject = this.getPropertyObject(oasObject);
        if (propertyObject == null) {
            OasObjectPropertyLocation propertyLoc = location.property(this.getPropertyName(), this.getPropertyType());
            return Collections.singletonList(new OasViolation(propertyLoc, "Required"));
        }
        if (propertyObject != null && String.class.equals(propertyObject.getClass()) && StringUtils.isBlank((CharSequence)((CharSequence)propertyObject))) {
            OasObjectPropertyLocation propertyLoc = location.property(this.getPropertyName(), this.getPropertyType());
            return Collections.singletonList(new OasViolation(propertyLoc, "Required"));
        }
        return Collections.emptyList();
    }

    protected abstract String get$ref(T var1);

    protected abstract P getPropertyObject(T var1);

    protected abstract String getPropertyName();

    protected abstract OasObjectType getPropertyType();
}

