/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FileUtils {
    public static void createDirectory(String pathName) throws IOException {
        if (pathName == null) {
            throw new IOException("Path is null");
        }
        File path = new File(pathName);
        if (path.exists()) {
            return;
        }
        if (!path.mkdirs()) {
            throw new IOException("Failed to create directory");
        }
    }

    public static Path createTempDirectory(String pathName) throws IOException {
        FileUtils.createDirectory(pathName);
        return Files.createTempDirectory(Paths.get(new File(pathName).toURI()), "", new FileAttribute[0]);
    }

    public static Map<String, byte[]> getFilesGroupByFilename(String pathName) throws IOException {
        if (pathName == null) {
            throw new IOException("Path is null");
        }
        if (!new File(pathName).exists()) {
            throw new IOException("Path " + pathName + " is not exists");
        }
        final HashMap<String, byte[]> filesGroup = new HashMap<String, byte[]>();
        File path = new File(pathName);
        Files.walkFileTree(Paths.get(path.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                filesGroup.put(file.toFile().getName(), Files.readAllBytes(file));
                return super.visitFile(file, attrs);
            }
        });
        return filesGroup;
    }

    public static void deleteDirectory(String pathName) throws IOException {
        File path = new File(pathName);
        if (!path.isDirectory()) {
            if (path.exists()) {
                Files.delete(Paths.get(pathName, new String[0]));
            }
            return;
        }
        File[] files = path.listFiles();
        for (File file : Objects.requireNonNull(files)) {
            FileUtils.deleteDirectory(file.getCanonicalPath());
        }
        Files.delete(Paths.get(pathName, new String[0]));
    }
}

