/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.internal.Bracket;
import org.commonmark.internal.Delimiter;
import org.commonmark.internal.ReferenceParser;
import org.commonmark.internal.inline.AsteriskDelimiterProcessor;
import org.commonmark.internal.inline.UnderscoreDelimiterProcessor;
import org.commonmark.internal.util.Escaping;
import org.commonmark.internal.util.Html5Entities;
import org.commonmark.node.Code;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.delimiter.DelimiterProcessor;

public class InlineParserImpl
implements InlineParser,
ReferenceParser {
    private static final String ESCAPED_CHAR = "\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]";
    private static final String REG_CHAR = "[^\\\\()\\x00-\\x20]";
    private static final String IN_PARENS_NOSP = "\\(([^\\\\()\\x00-\\x20]|\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-])*\\)";
    private static final String HTMLCOMMENT = "<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->";
    private static final String PROCESSINGINSTRUCTION = "[<][?].*?[?][>]";
    private static final String DECLARATION = "<![A-Z]+\\s+[^>]*>";
    private static final String CDATA = "<!\\[CDATA\\[[\\s\\S]*?\\]\\]>";
    private static final String HTMLTAG = "(?:<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>|</[A-Za-z][A-Za-z0-9-]*\\s*[>]|<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->|[<][?].*?[?][>]|<![A-Z]+\\s+[^>]*>|<!\\[CDATA\\[[\\s\\S]*?\\]\\]>)";
    private static final String ENTITY = "&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});";
    private static final String ASCII_PUNCTUATION = "'!\"#\\$%&\\(\\)\\*\\+,\\-\\./:;<=>\\?@\\[\\\\\\]\\^_`\\{\\|\\}~";
    private static final Pattern PUNCTUATION = Pattern.compile("^['!\"#\\$%&\\(\\)\\*\\+,\\-\\./:;<=>\\?@\\[\\\\\\]\\^_`\\{\\|\\}~\\p{Pc}\\p{Pd}\\p{Pe}\\p{Pf}\\p{Pi}\\p{Po}\\p{Ps}]");
    private static final Pattern HTML_TAG = Pattern.compile("^(?:<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>|</[A-Za-z][A-Za-z0-9-]*\\s*[>]|<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->|[<][?].*?[?][>]|<![A-Z]+\\s+[^>]*>|<!\\[CDATA\\[[\\s\\S]*?\\]\\]>)", 2);
    private static final Pattern LINK_TITLE = Pattern.compile("^(?:\"(\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|[^\"\\x00])*\"|'(\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|[^'\\x00])*'|\\((\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|[^)\\x00])*\\))");
    private static final Pattern LINK_DESTINATION_BRACES = Pattern.compile("^(?:[<](?:[^<> \\t\\n\\\\\\x00]|\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|\\\\)*[>])");
    private static final Pattern LINK_DESTINATION = Pattern.compile("^(?:[^\\\\()\\x00-\\x20]+|\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|\\\\|\\(([^\\\\()\\x00-\\x20]|\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-])*\\))*");
    private static final Pattern LINK_LABEL = Pattern.compile("^\\[(?:[^\\\\\\[\\]]|\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|\\\\){0,999}\\]");
    private static final Pattern ESCAPABLE = Pattern.compile("^[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]");
    private static final Pattern ENTITY_HERE = Pattern.compile("^&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});", 2);
    private static final Pattern TICKS = Pattern.compile("`+");
    private static final Pattern TICKS_HERE = Pattern.compile("^`+");
    private static final Pattern EMAIL_AUTOLINK = Pattern.compile("^<([a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)>");
    private static final Pattern AUTOLINK = Pattern.compile("^<[a-zA-Z][a-zA-Z0-9.+-]{1,31}:[^<>\u0000- ]*>");
    private static final Pattern SPNL = Pattern.compile("^ *(?:\n *)?");
    private static final Pattern UNICODE_WHITESPACE_CHAR = Pattern.compile("^[\\p{Zs}\t\r\n\f]");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern FINAL_SPACE = Pattern.compile(" *$");
    private static final Pattern LINE_END = Pattern.compile("^ *(?:\n|$)");
    private final BitSet specialCharacters;
    private final BitSet delimiterCharacters;
    private final Map<Character, DelimiterProcessor> delimiterProcessors;
    private Map<String, Link> referenceMap = new HashMap<String, Link>();
    private Node block;
    private String input;
    private int index;
    private Delimiter lastDelimiter;
    private Bracket lastBracket;

    public InlineParserImpl(List<DelimiterProcessor> delimiterProcessors) {
        this.delimiterProcessors = InlineParserImpl.calculateDelimiterProcessors(delimiterProcessors);
        this.delimiterCharacters = InlineParserImpl.calculateDelimiterCharacters(this.delimiterProcessors.keySet());
        this.specialCharacters = InlineParserImpl.calculateSpecialCharacters(this.delimiterCharacters);
    }

    public static BitSet calculateDelimiterCharacters(Set<Character> characters) {
        BitSet bitSet = new BitSet();
        for (Character character : characters) {
            bitSet.set(character.charValue());
        }
        return bitSet;
    }

    public static BitSet calculateSpecialCharacters(BitSet delimiterCharacters) {
        BitSet bitSet = new BitSet();
        bitSet.or(delimiterCharacters);
        bitSet.set(10);
        bitSet.set(96);
        bitSet.set(91);
        bitSet.set(93);
        bitSet.set(92);
        bitSet.set(33);
        bitSet.set(60);
        bitSet.set(38);
        return bitSet;
    }

    public static Map<Character, DelimiterProcessor> calculateDelimiterProcessors(List<DelimiterProcessor> delimiterProcessors) {
        HashMap<Character, DelimiterProcessor> map = new HashMap<Character, DelimiterProcessor>();
        InlineParserImpl.addDelimiterProcessors(Arrays.asList(new AsteriskDelimiterProcessor(), new UnderscoreDelimiterProcessor()), map);
        InlineParserImpl.addDelimiterProcessors(delimiterProcessors, map);
        return map;
    }

    private static void addDelimiterProcessors(Iterable<DelimiterProcessor> delimiterProcessors, Map<Character, DelimiterProcessor> map) {
        for (DelimiterProcessor delimiterProcessor : delimiterProcessors) {
            char opening = delimiterProcessor.getOpeningCharacter();
            InlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map);
            char closing = delimiterProcessor.getClosingCharacter();
            if (opening == closing) continue;
            InlineParserImpl.addDelimiterProcessorForChar(closing, delimiterProcessor, map);
        }
    }

    private static void addDelimiterProcessorForChar(char delimiterChar, DelimiterProcessor toAdd, Map<Character, DelimiterProcessor> delimiterProcessors) {
        DelimiterProcessor existing = delimiterProcessors.put(Character.valueOf(delimiterChar), toAdd);
        if (existing != null) {
            throw new IllegalArgumentException("Delimiter processor conflict with delimiter char '" + delimiterChar + "'");
        }
    }

    @Override
    public void parse(String content, Node block) {
        boolean moreToParse;
        this.block = block;
        this.input = content.trim();
        this.index = 0;
        this.lastDelimiter = null;
        this.lastBracket = null;
        while (moreToParse = this.parseInline()) {
        }
        this.processDelimiters(null);
        this.mergeTextNodes(block.getFirstChild(), block.getLastChild());
    }

    @Override
    public int parseReference(String s) {
        this.input = s;
        this.index = 0;
        int startIndex = this.index++;
        int matchChars = this.parseLinkLabel();
        if (matchChars == 0) {
            return 0;
        }
        String rawLabel = this.input.substring(0, matchChars);
        if (this.peek() != ':') {
            return 0;
        }
        this.spnl();
        String dest = this.parseLinkDestination();
        if (dest == null || dest.length() == 0) {
            return 0;
        }
        int beforeTitle = this.index;
        this.spnl();
        String title = this.parseLinkTitle();
        if (title == null) {
            this.index = beforeTitle;
        }
        boolean atLineEnd = true;
        if (this.index != this.input.length() && this.match(LINE_END) == null) {
            if (title == null) {
                atLineEnd = false;
            } else {
                title = null;
                this.index = beforeTitle;
                boolean bl = atLineEnd = this.match(LINE_END) != null;
            }
        }
        if (!atLineEnd) {
            return 0;
        }
        String normalizedLabel = Escaping.normalizeReference(rawLabel);
        if (normalizedLabel.isEmpty()) {
            return 0;
        }
        if (!this.referenceMap.containsKey(normalizedLabel)) {
            Link link = new Link(dest, title);
            this.referenceMap.put(normalizedLabel, link);
        }
        return this.index - startIndex;
    }

    private Text appendText(CharSequence text, int beginIndex, int endIndex) {
        return this.appendText(text.subSequence(beginIndex, endIndex));
    }

    private Text appendText(CharSequence text) {
        Text node = new Text(text.toString());
        this.appendNode(node);
        return node;
    }

    private void appendNode(Node node) {
        this.block.appendChild(node);
    }

    private boolean parseInline() {
        boolean res;
        char c = this.peek();
        if (c == '\u0000') {
            return false;
        }
        switch (c) {
            case '\n': {
                res = this.parseNewline();
                break;
            }
            case '\\': {
                res = this.parseBackslash();
                break;
            }
            case '`': {
                res = this.parseBackticks();
                break;
            }
            case '[': {
                res = this.parseOpenBracket();
                break;
            }
            case '!': {
                res = this.parseBang();
                break;
            }
            case ']': {
                res = this.parseCloseBracket();
                break;
            }
            case '<': {
                res = this.parseAutolink() || this.parseHtmlInline();
                break;
            }
            case '&': {
                res = this.parseEntity();
                break;
            }
            default: {
                boolean isDelimiter = this.delimiterCharacters.get(c);
                if (isDelimiter) {
                    DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c));
                    res = this.parseDelimiters(delimiterProcessor, c);
                    break;
                }
                res = this.parseString();
            }
        }
        if (!res) {
            ++this.index;
            String literal = String.valueOf(c);
            this.appendText(literal);
        }
        return true;
    }

    private String match(Pattern re) {
        if (this.index >= this.input.length()) {
            return null;
        }
        Matcher matcher = re.matcher(this.input);
        matcher.region(this.index, this.input.length());
        boolean m = matcher.find();
        if (m) {
            this.index = matcher.end();
            return matcher.group();
        }
        return null;
    }

    private char peek() {
        if (this.index < this.input.length()) {
            return this.input.charAt(this.index);
        }
        return '\u0000';
    }

    private boolean spnl() {
        this.match(SPNL);
        return true;
    }

    private boolean parseNewline() {
        ++this.index;
        Node lastChild = this.block.getLastChild();
        if (lastChild != null && lastChild instanceof Text && ((Text)lastChild).getLiteral().endsWith(" ")) {
            int spaces;
            Text text = (Text)lastChild;
            String literal = text.getLiteral();
            Matcher matcher = FINAL_SPACE.matcher(literal);
            int n = spaces = matcher.find() ? matcher.end() - matcher.start() : 0;
            if (spaces > 0) {
                text.setLiteral(literal.substring(0, literal.length() - spaces));
            }
            this.appendNode(spaces >= 2 ? new HardLineBreak() : new SoftLineBreak());
        } else {
            this.appendNode(new SoftLineBreak());
        }
        while (this.peek() == ' ') {
            ++this.index;
        }
        return true;
    }

    private boolean parseBackslash() {
        ++this.index;
        if (this.peek() == '\n') {
            this.appendNode(new HardLineBreak());
            ++this.index;
        } else if (this.index < this.input.length() && ESCAPABLE.matcher(this.input.substring(this.index, this.index + 1)).matches()) {
            this.appendText(this.input, this.index, this.index + 1);
            ++this.index;
        } else {
            this.appendText("\\");
        }
        return true;
    }

    private boolean parseBackticks() {
        String matched;
        String ticks = this.match(TICKS_HERE);
        if (ticks == null) {
            return false;
        }
        int afterOpenTicks = this.index;
        while ((matched = this.match(TICKS)) != null) {
            if (!matched.equals(ticks)) continue;
            Code node = new Code();
            String content = this.input.substring(afterOpenTicks, this.index - ticks.length());
            String literal = WHITESPACE.matcher(content.trim()).replaceAll(" ");
            node.setLiteral(literal);
            this.appendNode(node);
            return true;
        }
        this.index = afterOpenTicks;
        this.appendText(ticks);
        return true;
    }

    private boolean parseDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        DelimiterData res = this.scanDelimiters(delimiterProcessor, delimiterChar);
        if (res == null) {
            return false;
        }
        int numDelims = res.count;
        int startIndex = this.index;
        this.index += numDelims;
        Text node = this.appendText(this.input, startIndex, this.index);
        this.lastDelimiter = new Delimiter(node, delimiterChar, res.canOpen, res.canClose, this.lastDelimiter);
        this.lastDelimiter.numDelims = numDelims;
        if (this.lastDelimiter.previous != null) {
            this.lastDelimiter.previous.next = this.lastDelimiter;
        }
        return true;
    }

    private boolean parseOpenBracket() {
        int startIndex = this.index++;
        Text node = this.appendText("[");
        this.addBracket(Bracket.link(node, startIndex, this.lastBracket, this.lastDelimiter));
        return true;
    }

    private boolean parseBang() {
        int startIndex = this.index++;
        if (this.peek() == '[') {
            ++this.index;
            Text node = this.appendText("![");
            this.addBracket(Bracket.image(node, startIndex + 1, this.lastBracket, this.lastDelimiter));
        } else {
            this.appendText("!");
        }
        return true;
    }

    private boolean parseCloseBracket() {
        ++this.index;
        int startIndex = this.index++;
        Bracket opener = this.lastBracket;
        if (opener == null) {
            this.appendText("]");
            return true;
        }
        if (!opener.allowed) {
            this.appendText("]");
            this.removeLastBracket();
            return true;
        }
        String dest = null;
        String title = null;
        boolean isLinkOrImage = false;
        if (this.peek() == '(') {
            this.spnl();
            dest = this.parseLinkDestination();
            if (dest != null) {
                this.spnl();
                if (WHITESPACE.matcher(this.input.substring(this.index - 1, this.index)).matches()) {
                    title = this.parseLinkTitle();
                    this.spnl();
                }
                if (this.peek() == ')') {
                    ++this.index;
                    isLinkOrImage = true;
                } else {
                    this.index = startIndex;
                }
            }
        }
        if (!isLinkOrImage) {
            Link link;
            int beforeLabel = this.index;
            int labelLength = this.parseLinkLabel();
            String ref = null;
            if (labelLength > 2) {
                ref = this.input.substring(beforeLabel, beforeLabel + labelLength);
            } else if (!opener.bracketAfter) {
                ref = this.input.substring(opener.index, startIndex);
            }
            if (ref != null && (link = this.referenceMap.get(Escaping.normalizeReference(ref))) != null) {
                dest = link.getDestination();
                title = link.getTitle();
                isLinkOrImage = true;
            }
        }
        if (isLinkOrImage) {
            Node linkOrImage = opener.image ? new Image(dest, title) : new Link(dest, title);
            Node node = opener.node.getNext();
            while (node != null) {
                Node next = node.getNext();
                linkOrImage.appendChild(node);
                node = next;
            }
            this.appendNode(linkOrImage);
            this.processDelimiters(opener.previousDelimiter);
            this.mergeTextNodes(linkOrImage.getFirstChild(), linkOrImage.getLastChild());
            opener.node.unlink();
            this.removeLastBracket();
            if (!opener.image) {
                Bracket bracket = this.lastBracket;
                while (bracket != null) {
                    if (!bracket.image) {
                        bracket.allowed = false;
                    }
                    bracket = bracket.previous;
                }
            }
            return true;
        }
        this.appendText("]");
        this.removeLastBracket();
        this.index = startIndex;
        return true;
    }

    private void addBracket(Bracket bracket) {
        if (this.lastBracket != null) {
            this.lastBracket.bracketAfter = true;
        }
        this.lastBracket = bracket;
    }

    private void removeLastBracket() {
        this.lastBracket = this.lastBracket.previous;
    }

    private String parseLinkDestination() {
        String res = this.match(LINK_DESTINATION_BRACES);
        if (res != null) {
            if (res.length() == 2) {
                return "";
            }
            return Escaping.unescapeString(res.substring(1, res.length() - 1));
        }
        res = this.match(LINK_DESTINATION);
        if (res != null) {
            return Escaping.unescapeString(res);
        }
        return null;
    }

    private String parseLinkTitle() {
        String title = this.match(LINK_TITLE);
        if (title != null) {
            return Escaping.unescapeString(title.substring(1, title.length() - 1));
        }
        return null;
    }

    private int parseLinkLabel() {
        String m = this.match(LINK_LABEL);
        return m == null ? 0 : m.length();
    }

    private boolean parseAutolink() {
        String m = this.match(EMAIL_AUTOLINK);
        if (m != null) {
            String dest = m.substring(1, m.length() - 1);
            Link node = new Link("mailto:" + dest, null);
            node.appendChild(new Text(dest));
            this.appendNode(node);
            return true;
        }
        m = this.match(AUTOLINK);
        if (m != null) {
            String dest = m.substring(1, m.length() - 1);
            Link node = new Link(dest, null);
            node.appendChild(new Text(dest));
            this.appendNode(node);
            return true;
        }
        return false;
    }

    private boolean parseHtmlInline() {
        String m = this.match(HTML_TAG);
        if (m != null) {
            HtmlInline node = new HtmlInline();
            node.setLiteral(m);
            this.appendNode(node);
            return true;
        }
        return false;
    }

    private boolean parseEntity() {
        String m = this.match(ENTITY_HERE);
        if (m != null) {
            this.appendText(Html5Entities.entityToString(m));
            return true;
        }
        return false;
    }

    private boolean parseString() {
        int begin = this.index;
        int length = this.input.length();
        while (this.index != length && !this.specialCharacters.get(this.input.charAt(this.index))) {
            ++this.index;
        }
        if (begin != this.index) {
            this.appendText(this.input, begin, this.index);
            return true;
        }
        return false;
    }

    private DelimiterData scanDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        boolean canClose;
        boolean canOpen;
        boolean rightFlanking;
        int startIndex = this.index;
        int delimiterCount = 0;
        while (this.peek() == delimiterChar) {
            ++delimiterCount;
            ++this.index;
        }
        if (delimiterCount < delimiterProcessor.getMinLength()) {
            this.index = startIndex;
            return null;
        }
        String before = startIndex == 0 ? "\n" : this.input.substring(startIndex - 1, startIndex);
        char charAfter = this.peek();
        String after = charAfter == '\u0000' ? "\n" : String.valueOf(charAfter);
        boolean beforeIsPunctuation = PUNCTUATION.matcher(before).matches();
        boolean beforeIsWhitespace = UNICODE_WHITESPACE_CHAR.matcher(before).matches();
        boolean afterIsPunctuation = PUNCTUATION.matcher(after).matches();
        boolean afterIsWhitespace = UNICODE_WHITESPACE_CHAR.matcher(after).matches();
        boolean leftFlanking = !afterIsWhitespace && (!afterIsPunctuation || beforeIsWhitespace || beforeIsPunctuation);
        boolean bl = rightFlanking = !beforeIsWhitespace && (!beforeIsPunctuation || afterIsWhitespace || afterIsPunctuation);
        if (delimiterChar == '_') {
            canOpen = leftFlanking && (!rightFlanking || beforeIsPunctuation);
            canClose = rightFlanking && (!leftFlanking || afterIsPunctuation);
        } else {
            canOpen = leftFlanking && delimiterChar == delimiterProcessor.getOpeningCharacter();
            canClose = rightFlanking && delimiterChar == delimiterProcessor.getClosingCharacter();
        }
        this.index = startIndex;
        return new DelimiterData(delimiterCount, canOpen, canClose);
    }

    private void processDelimiters(Delimiter stackBottom) {
        HashMap<Character, Delimiter> openersBottom = new HashMap<Character, Delimiter>();
        Delimiter closer = this.lastDelimiter;
        while (closer != null && closer.previous != stackBottom) {
            closer = closer.previous;
        }
        while (closer != null) {
            char delimiterChar = closer.delimiterChar;
            DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(delimiterChar));
            if (!closer.canClose || delimiterProcessor == null) {
                closer = closer.next;
                continue;
            }
            char openingDelimiterChar = delimiterProcessor.getOpeningCharacter();
            int useDelims = 0;
            boolean openerFound = false;
            boolean potentialOpenerFound = false;
            Delimiter opener = closer.previous;
            while (opener != null && opener != stackBottom && opener != openersBottom.get(Character.valueOf(delimiterChar))) {
                if (opener.canOpen && opener.delimiterChar == openingDelimiterChar) {
                    potentialOpenerFound = true;
                    useDelims = delimiterProcessor.getDelimiterUse(opener, closer);
                    if (useDelims > 0) {
                        openerFound = true;
                        break;
                    }
                }
                opener = opener.previous;
            }
            if (!openerFound) {
                if (!potentialOpenerFound) {
                    openersBottom.put(Character.valueOf(delimiterChar), closer.previous);
                    if (!closer.canOpen) {
                        this.removeDelimiterKeepNode(closer);
                    }
                }
                closer = closer.next;
                continue;
            }
            Text openerNode = opener.node;
            Text closerNode = closer.node;
            opener.numDelims -= useDelims;
            closer.numDelims -= useDelims;
            openerNode.setLiteral(openerNode.getLiteral().substring(0, openerNode.getLiteral().length() - useDelims));
            closerNode.setLiteral(closerNode.getLiteral().substring(0, closerNode.getLiteral().length() - useDelims));
            this.removeDelimitersBetween(opener, closer);
            this.mergeTextNodes(openerNode.getNext(), closerNode.getPrevious());
            delimiterProcessor.process(openerNode, closerNode, useDelims);
            if (opener.numDelims == 0) {
                this.removeDelimiterAndNode(opener);
            }
            if (closer.numDelims != 0) continue;
            Delimiter next = closer.next;
            this.removeDelimiterAndNode(closer);
            closer = next;
        }
        while (this.lastDelimiter != null && this.lastDelimiter != stackBottom) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
    }

    private void removeDelimitersBetween(Delimiter opener, Delimiter closer) {
        Delimiter delimiter = closer.previous;
        while (delimiter != null && delimiter != opener) {
            Delimiter previousDelimiter = delimiter.previous;
            this.removeDelimiterKeepNode(delimiter);
            delimiter = previousDelimiter;
        }
    }

    private void removeDelimiterAndNode(Delimiter delim) {
        Text node = delim.node;
        node.unlink();
        this.removeDelimiter(delim);
    }

    private void removeDelimiterKeepNode(Delimiter delim) {
        this.removeDelimiter(delim);
    }

    private void removeDelimiter(Delimiter delim) {
        if (delim.previous != null) {
            delim.previous.next = delim.next;
        }
        if (delim.next == null) {
            this.lastDelimiter = delim.previous;
        } else {
            delim.next.previous = delim.previous;
        }
    }

    private void mergeTextNodes(Node fromNode, Node toNode) {
        Text first = null;
        Text last = null;
        int length = 0;
        for (Node node = fromNode; node != null; node = node.getNext()) {
            if (node instanceof Text) {
                Text text = (Text)node;
                if (first == null) {
                    first = text;
                }
                length += text.getLiteral().length();
                last = text;
            } else {
                this.mergeIfNeeded(first, last, length);
                first = null;
                last = null;
                length = 0;
            }
            if (node == toNode) break;
        }
        this.mergeIfNeeded(first, last, length);
    }

    private void mergeIfNeeded(Text first, Text last, int textLength) {
        if (first != null && last != null && first != last) {
            StringBuilder sb = new StringBuilder(textLength);
            sb.append(first.getLiteral());
            Node stop = last.getNext();
            for (Node node = first.getNext(); node != stop; node = node.getNext()) {
                sb.append(((Text)node).getLiteral());
                Node unlink = node;
                unlink.unlink();
            }
            String literal = sb.toString();
            first.setLiteral(literal);
        }
    }

    private static class DelimiterData {
        final int count;
        final boolean canClose;
        final boolean canOpen;

        DelimiterData(int count, boolean canOpen, boolean canClose) {
            this.count = count;
            this.canOpen = canOpen;
            this.canClose = canClose;
        }
    }
}

