/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.config;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowSettings.class);
    public static final String DEFAULT_OUTPUT_DIR = ".";
    public static final boolean DEFAULT_VERBOSE = false;
    public static final boolean DEFAULT_SKIP_OVERWRITE = false;
    public static final boolean DEFAULT_REMOVE_OPERATION_ID_PREFIX = false;
    public static final boolean DEFAULT_LOG_TO_STDERR = false;
    public static final boolean DEFAULT_VALIDATE_SPEC = true;
    public static final boolean DEFAULT_ENABLE_POST_PROCESS_FILE = false;
    public static final boolean DEFAULT_ENABLE_MINIMAL_UPDATE = false;
    public static final boolean DEFAULT_STRICT_SPEC_BEHAVIOR = true;
    public static final String DEFAULT_TEMPLATING_ENGINE_NAME = "mustache";
    public static final ImmutableMap<String, String> DEFAULT_SYSTEM_PROPERTIES = ImmutableMap.of();
    private String inputSpec;
    private String outputDir = ".";
    private boolean verbose = false;
    private boolean skipOverwrite = false;
    private boolean removeOperationIdPrefix = false;
    private boolean logToStderr = false;
    private boolean validateSpec = true;
    private boolean enablePostProcessFile = false;
    private boolean enableMinimalUpdate = false;
    private boolean strictSpecBehavior = true;
    private String templateDir;
    private String templatingEngineName = "mustache";
    private String ignoreFileOverride;
    private ImmutableMap<String, String> systemProperties = DEFAULT_SYSTEM_PROPERTIES;

    private WorkflowSettings(Builder builder) {
        this.inputSpec = builder.inputSpec;
        this.outputDir = builder.outputDir;
        this.verbose = builder.verbose;
        this.skipOverwrite = builder.skipOverwrite;
        this.removeOperationIdPrefix = builder.removeOperationIdPrefix;
        this.logToStderr = builder.logToStderr;
        this.validateSpec = builder.validateSpec;
        this.enablePostProcessFile = builder.enablePostProcessFile;
        this.enableMinimalUpdate = builder.enableMinimalUpdate;
        this.strictSpecBehavior = builder.strictSpecBehavior;
        this.templateDir = builder.templateDir;
        this.templatingEngineName = builder.templatingEngineName;
        this.ignoreFileOverride = builder.ignoreFileOverride;
        this.systemProperties = ImmutableMap.copyOf((Map)builder.systemProperties);
    }

    public WorkflowSettings() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkflowSettings copy) {
        Builder builder = WorkflowSettings.newBuilder();
        builder.inputSpec = copy.getInputSpec();
        builder.outputDir = copy.getOutputDir();
        builder.verbose = copy.isVerbose();
        builder.skipOverwrite = copy.isSkipOverwrite();
        builder.removeOperationIdPrefix = copy.isRemoveOperationIdPrefix();
        builder.logToStderr = copy.isLogToStderr();
        builder.validateSpec = copy.isValidateSpec();
        builder.enablePostProcessFile = copy.isEnablePostProcessFile();
        builder.enableMinimalUpdate = copy.isEnableMinimalUpdate();
        builder.strictSpecBehavior = copy.isStrictSpecBehavior();
        builder.templatingEngineName = copy.getTemplatingEngineName();
        builder.ignoreFileOverride = copy.getIgnoreFileOverride();
        builder.systemProperties = (Map)ImmutableMap.copyOf(copy.getSystemProperties());
        builder.withTemplateDir(copy.getTemplateDir());
        return builder;
    }

    public String getInputSpec() {
        return this.inputSpec;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    public boolean isRemoveOperationIdPrefix() {
        return this.removeOperationIdPrefix;
    }

    public boolean isLogToStderr() {
        return this.logToStderr;
    }

    public boolean isValidateSpec() {
        return this.validateSpec;
    }

    public boolean isEnablePostProcessFile() {
        return this.enablePostProcessFile;
    }

    public boolean isEnableMinimalUpdate() {
        return this.enableMinimalUpdate;
    }

    public boolean isStrictSpecBehavior() {
        return this.strictSpecBehavior;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public String getTemplatingEngineName() {
        return this.templatingEngineName;
    }

    public String getIgnoreFileOverride() {
        return this.ignoreFileOverride;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public String toString() {
        return "WorkflowSettings{inputSpec='" + this.inputSpec + '\'' + ", outputDir='" + this.outputDir + '\'' + ", verbose=" + this.verbose + ", skipOverwrite=" + this.skipOverwrite + ", removeOperationIdPrefix=" + this.removeOperationIdPrefix + ", logToStderr=" + this.logToStderr + ", validateSpec=" + this.validateSpec + ", enablePostProcessFile=" + this.enablePostProcessFile + ", enableMinimalUpdate=" + this.enableMinimalUpdate + ", strictSpecBehavior=" + this.strictSpecBehavior + ", templateDir='" + this.templateDir + '\'' + ", templatingEngineName='" + this.templatingEngineName + '\'' + ", ignoreFileOverride='" + this.ignoreFileOverride + '\'' + ", systemProperties=" + this.systemProperties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkflowSettings)) {
            return false;
        }
        WorkflowSettings that = (WorkflowSettings)o;
        return this.isVerbose() == that.isVerbose() && this.isSkipOverwrite() == that.isSkipOverwrite() && this.isRemoveOperationIdPrefix() == that.isRemoveOperationIdPrefix() && this.isLogToStderr() == that.isLogToStderr() && this.isValidateSpec() == that.isValidateSpec() && this.isEnablePostProcessFile() == that.isEnablePostProcessFile() && this.isEnableMinimalUpdate() == that.isEnableMinimalUpdate() && this.isStrictSpecBehavior() == that.isStrictSpecBehavior() && Objects.equals(this.getInputSpec(), that.getInputSpec()) && Objects.equals(this.getOutputDir(), that.getOutputDir()) && Objects.equals(this.getTemplateDir(), that.getTemplateDir()) && Objects.equals(this.getTemplatingEngineName(), that.getTemplatingEngineName()) && Objects.equals(this.getIgnoreFileOverride(), that.getIgnoreFileOverride()) && Objects.equals(this.getSystemProperties(), that.getSystemProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getInputSpec(), this.getOutputDir(), this.isVerbose(), this.isSkipOverwrite(), this.isRemoveOperationIdPrefix(), this.isLogToStderr(), this.isValidateSpec(), this.isEnablePostProcessFile(), this.isEnableMinimalUpdate(), this.isStrictSpecBehavior(), this.getTemplateDir(), this.getTemplatingEngineName(), this.getIgnoreFileOverride(), this.getSystemProperties());
    }

    public static final class Builder {
        private String inputSpec;
        private String outputDir = ".";
        private Boolean verbose = false;
        private Boolean skipOverwrite = false;
        private Boolean removeOperationIdPrefix = false;
        private Boolean logToStderr = false;
        private Boolean validateSpec = true;
        private Boolean enablePostProcessFile = false;
        private Boolean enableMinimalUpdate = false;
        private Boolean strictSpecBehavior = true;
        private String templateDir;
        private String templatingEngineName = "mustache";
        private String ignoreFileOverride;
        private Map<String, String> systemProperties = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withInputSpec(String inputSpec) {
            if (inputSpec != null) {
                this.inputSpec = inputSpec;
            }
            return this;
        }

        public Builder withOutputDir(String outputDir) {
            this.outputDir = outputDir != null ? Paths.get(outputDir, new String[0]).toAbsolutePath().toString() : WorkflowSettings.DEFAULT_OUTPUT_DIR;
            return this;
        }

        public Builder withVerbose(Boolean verbose) {
            this.verbose = verbose != null ? verbose : Boolean.valueOf(false);
            return this;
        }

        public Builder withSkipOverwrite(Boolean skipOverwrite) {
            this.skipOverwrite = skipOverwrite != null ? skipOverwrite : Boolean.valueOf(false);
            return this;
        }

        public Builder withRemoveOperationIdPrefix(Boolean removeOperationIdPrefix) {
            this.removeOperationIdPrefix = removeOperationIdPrefix != null ? removeOperationIdPrefix : Boolean.valueOf(false);
            return this;
        }

        public Builder withLogToStderr(Boolean logToStderr) {
            this.logToStderr = logToStderr != null ? logToStderr : Boolean.valueOf(false);
            return this;
        }

        public Builder withValidateSpec(Boolean validateSpec) {
            this.validateSpec = validateSpec != null ? validateSpec : Boolean.valueOf(true);
            return this;
        }

        public Builder withEnablePostProcessFile(Boolean enablePostProcessFile) {
            this.enablePostProcessFile = enablePostProcessFile != null ? enablePostProcessFile : Boolean.valueOf(false);
            return this;
        }

        public Builder withEnableMinimalUpdate(Boolean enableMinimalUpdate) {
            this.enableMinimalUpdate = enableMinimalUpdate != null ? enableMinimalUpdate : Boolean.valueOf(false);
            return this;
        }

        public Builder withStrictSpecBehavior(Boolean strictSpecBehavior) {
            this.strictSpecBehavior = strictSpecBehavior != null ? strictSpecBehavior : Boolean.valueOf(true);
            return this;
        }

        public Builder withTemplateDir(String templateDir) {
            if (templateDir != null) {
                File f = new File(templateDir);
                if (!f.exists() || !f.isDirectory()) {
                    throw new IllegalArgumentException("Template directory " + templateDir + " does not exist.");
                }
                this.templateDir = Paths.get(f.toURI()).toAbsolutePath().toString();
            }
            return this;
        }

        public Builder withTemplatingEngineName(String templatingEngineName) {
            this.templatingEngineName = templatingEngineName != null ? templatingEngineName : WorkflowSettings.DEFAULT_TEMPLATING_ENGINE_NAME;
            return this;
        }

        public Builder withIgnoreFileOverride(String ignoreFileOverride) {
            this.ignoreFileOverride = ignoreFileOverride;
            return this;
        }

        public Builder withSystemProperties(Map<String, String> systemProperties) {
            if (systemProperties != null) {
                this.systemProperties = systemProperties;
            }
            return this;
        }

        public Builder withSystemProperty(String key, String value) {
            if (this.systemProperties == null) {
                this.systemProperties = new HashMap<String, String>();
            }
            this.systemProperties.put(key, value);
            return this;
        }

        public WorkflowSettings build() {
            WorkflowSettings instance = new WorkflowSettings(this);
            LOGGER.debug("WorkflowSettings#build: %s", (Object)instance.toString());
            return instance;
        }
    }
}

