/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.event;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.SimpleSubscriber;

public class SimpleEventBus
extends EventBus {
    private final Map<Object, List<SimpleSubscriber>> subscribersMap = new ConcurrentHashMapEx<Object, List<SimpleSubscriber>>();
    private Map<Class<?>, List<SimpleSubscriber>> subscribersCache = new ConcurrentHashMapEx();

    private List<SimpleSubscriber> collectSubscribers(Object instance) {
        Method[] methods;
        ArrayList<SimpleSubscriber> subscribers = new ArrayList<SimpleSubscriber>();
        for (Method method : methods = MethodUtils.getMethodsWithAnnotation(instance.getClass(), Subscribe.class, (boolean)true, (boolean)true)) {
            SimpleSubscriber subscriber = new SimpleSubscriber(instance, method);
            subscribers.add(subscriber);
        }
        return subscribers;
    }

    public void register(Object instance) {
        this.subscribersMap.computeIfAbsent(instance, this::collectSubscribers);
        this.subscribersCache = new ConcurrentHashMapEx();
    }

    public void unregister(Object instance) {
        if (this.subscribersMap.remove(instance) != null) {
            this.subscribersCache = new ConcurrentHashMapEx();
        }
    }

    public void post(Object event) {
        List subscribers = this.subscribersCache.computeIfAbsent(event.getClass(), this::collectSubscriberForEvent);
        for (SimpleSubscriber subscriber : subscribers) {
            subscriber.dispatchEvent(event);
        }
    }

    private List<SimpleSubscriber> collectSubscriberForEvent(Class<?> eventClass) {
        ArrayList<SimpleSubscriber> subscribersForEvent = new ArrayList<SimpleSubscriber>();
        for (List<SimpleSubscriber> subscribers : this.subscribersMap.values()) {
            for (SimpleSubscriber subscriber : subscribers) {
                if (!subscriber.getMethod().getParameterTypes()[0].isAssignableFrom(eventClass)) continue;
                subscribersForEvent.add(subscriber);
            }
        }
        return subscribersForEvent;
    }
}

