/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.util.Map;

public class OpenAPISerializer
extends JsonSerializer<OpenAPI> {
    public void serialize(OpenAPI value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value != null) {
            gen.writeStartObject();
            gen.writeStringField("openapi", value.getOpenapi());
            if (value.getInfo() != null) {
                gen.writeObjectField("info", (Object)value.getInfo());
            }
            if (value.getExternalDocs() != null) {
                gen.writeObjectField("externalDocs", (Object)value.getExternalDocs());
            }
            if (value.getServers() != null) {
                gen.writeObjectField("servers", (Object)value.getServers());
            }
            if (value.getSecurity() != null) {
                gen.writeObjectField("security", (Object)value.getSecurity());
            }
            if (value.getTags() != null) {
                gen.writeObjectField("tags", (Object)value.getTags());
            }
            if (value.getPaths() != null) {
                gen.writeObjectField("paths", (Object)value.getPaths());
            }
            if (value.getComponents() != null) {
                gen.writeObjectField("components", (Object)value.getComponents());
            }
            if (value.getExtensions() != null) {
                for (Map.Entry e : value.getExtensions().entrySet()) {
                    gen.writeObjectField((String)e.getKey(), e.getValue());
                }
            }
            gen.writeEndObject();
        }
    }
}

