/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;

public class CatalogComponentListCommand
extends AbstractCamelCommand {
    private static final String TITLE_COLUMN_LABEL = "Title";
    private static final String SCHEME_COLUMN_LABEL = "Scheme";
    private static final String LABEL_COLUMN_LABEL = "Label";
    private static final String MAVEN_COLUMN_LABEL = "Maven Coordinate";
    private static final String DESCRIPTION_COLUMN_LABEL = "Description";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    private boolean verbose;
    private String label;

    public CatalogComponentListCommand(boolean verbose, String label) {
        this.verbose = verbose;
        this.label = label;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> components = camelController.listComponentsCatalog(this.label);
        if (components == null || components.isEmpty()) {
            return null;
        }
        Map<String, Integer> columnWidths = this.computeColumnWidths(components);
        String headerFormat = this.buildFormatString(columnWidths, true);
        String rowFormat = this.buildFormatString(columnWidths, false);
        if (this.verbose) {
            out.println(String.format(headerFormat, TITLE_COLUMN_LABEL, SCHEME_COLUMN_LABEL, LABEL_COLUMN_LABEL, MAVEN_COLUMN_LABEL));
            out.println(String.format(headerFormat, "-----", "------", "-----", "----------------"));
        } else {
            out.println(String.format(headerFormat, TITLE_COLUMN_LABEL, DESCRIPTION_COLUMN_LABEL));
            out.println(String.format(headerFormat, "-----", "-----------"));
        }
        for (Map<String, String> component : components) {
            String title;
            if (this.verbose) {
                title = this.safeNull(component.get("title"));
                String scheme = this.safeNull(component.get("name"));
                String label = this.safeNull(component.get("label"));
                String maven = "";
                if (component.containsKey("groupId") && component.containsKey("artifactId") && component.containsKey("version")) {
                    maven = component.get("groupId") + "/" + component.get("artifactId") + "/" + component.get("version");
                }
                out.println(String.format(rowFormat, title, scheme, label, maven));
                continue;
            }
            title = this.safeNull(component.get("title"));
            String description = this.safeNull(component.get("description"));
            out.println(String.format(rowFormat, title, description));
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(Iterable<Map<String, String>> components) throws Exception {
        if (components == null) {
            return null;
        }
        int maxTitleLen = TITLE_COLUMN_LABEL.length();
        int maxSchemeLen = SCHEME_COLUMN_LABEL.length();
        int maxLabelLen = LABEL_COLUMN_LABEL.length();
        int maxMavenLen = MAVEN_COLUMN_LABEL.length();
        int maxDescriptionLen = DESCRIPTION_COLUMN_LABEL.length();
        for (Map<String, String> component : components) {
            String description;
            String label;
            String title;
            String name = component.get("name");
            if (name != null) {
                maxSchemeLen = Math.max(maxSchemeLen, name.length());
            }
            if ((title = component.get("title")) != null) {
                maxTitleLen = Math.max(maxTitleLen, title.length());
            }
            if ((label = component.get("label")) != null) {
                maxLabelLen = Math.max(maxLabelLen, label.length());
            }
            if (component.containsKey("groupId") && component.containsKey("artifactId") && component.containsKey("version")) {
                String mvn = component.get("groupId") + "/" + component.get("artifactId") + "/" + component.get("version");
                maxMavenLen = Math.max(maxMavenLen, mvn.length());
            }
            if ((description = component.get("description")) == null) continue;
            maxDescriptionLen = Math.max(maxDescriptionLen, description.length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>();
        retval.put(TITLE_COLUMN_LABEL, maxTitleLen);
        retval.put(SCHEME_COLUMN_LABEL, maxSchemeLen);
        retval.put(LABEL_COLUMN_LABEL, maxLabelLen);
        retval.put(MAVEN_COLUMN_LABEL, maxMavenLen);
        retval.put(DESCRIPTION_COLUMN_LABEL, maxDescriptionLen);
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        if (this.verbose) {
            int titleLen = Math.min(columnWidths.get(TITLE_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            int schemeLen = Math.min(columnWidths.get(SCHEME_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            int labelLen = Math.min(columnWidths.get(LABEL_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            int mavenLen = Math.min(columnWidths.get(MAVEN_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
            titleLen = Math.max(12, titleLen);
            schemeLen = Math.max(12, schemeLen);
            labelLen = Math.max(12, labelLen);
            mavenLen = Math.max(12, mavenLen);
            StringBuilder retval = new StringBuilder(24);
            retval.append(fieldPreamble).append("%-").append(titleLen).append('.').append(titleLen).append('s').append(fieldPostamble).append(' ');
            retval.append(fieldPreamble).append("%-").append(schemeLen).append('.').append(schemeLen).append('s').append(fieldPostamble).append(' ');
            retval.append(fieldPreamble).append("%-").append(labelLen).append('.').append(labelLen).append('s').append(fieldPostamble).append(' ');
            retval.append(fieldPreamble).append("%-").append(mavenLen).append('.').append(mavenLen).append('s').append(fieldPostamble).append(' ');
            return retval.toString();
        }
        int titleLen = Math.min(columnWidths.get(TITLE_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        int descriptionLen = Math.min(columnWidths.get(DESCRIPTION_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        titleLen = Math.max(12, titleLen);
        descriptionLen = Math.max(12, descriptionLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(titleLen).append('.').append(titleLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(descriptionLen).append('.').append(descriptionLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth() {
        if (this.verbose) {
            return Integer.MAX_VALUE;
        }
        return 120;
    }
}

