/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.Compression;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.ForwardingFilter;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.Mac;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Random;
import org.apache.sshd.common.RequestHandler;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.TcpipForwarderFactory;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.session.ConnectionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface FactoryManager {
    public static final String WINDOW_SIZE = "window-size";
    public static final String MAX_PACKET_SIZE = "packet-size";
    public static final String NIO_WORKERS = "nio-workers";
    public static final int DEFAULT_NIO_WORKERS = Runtime.getRuntime().availableProcessors() + 1;
    public static final String AUTH_TIMEOUT = "auth-timeout";
    public static final String IDLE_TIMEOUT = "idle-timeout";
    public static final String DISCONNECT_TIMEOUT = "disconnect-timeout";
    public static final String CHANNEL_CLOSE_TIMEOUT = "channel-close-timeout";
    public static final String SOCKET_BACKLOG = "socket-backlog";
    public static final String SOCKET_KEEPALIVE = "socket-keepalive";
    public static final String SOCKET_SNDBUF = "socket-sndbuf";
    public static final String SOCKET_RCVBUF = "socket-rcvbuf";
    public static final String SOCKET_REUSEADDR = "socket-reuseaddr";
    public static final String SOCKET_LINGER = "socket-linger";
    public static final String TCP_NODELAY = "tcp-nodelay";

    public Map<String, String> getProperties();

    public String getVersion();

    public IoServiceFactory getIoServiceFactory();

    public List<NamedFactory<KeyExchange>> getKeyExchangeFactories();

    public List<NamedFactory<Cipher>> getCipherFactories();

    public List<NamedFactory<Compression>> getCompressionFactories();

    public List<NamedFactory<Mac>> getMacFactories();

    public List<NamedFactory<Signature>> getSignatureFactories();

    public KeyPairProvider getKeyPairProvider();

    public Factory<Random> getRandomFactory();

    public List<NamedFactory<Channel>> getChannelFactories();

    public SshAgentFactory getAgentFactory();

    public ScheduledExecutorService getScheduledExecutorService();

    public ForwardingFilter getTcpipForwardingFilter();

    public TcpipForwarderFactory getTcpipForwarderFactory();

    public FileSystemFactory getFileSystemFactory();

    public List<ServiceFactory> getServiceFactories();

    public List<RequestHandler<ConnectionService>> getGlobalRequestHandlers();
}

