/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class SshdSocketAddress
extends SocketAddress {
    private final String hostName;
    private final int port;

    public SshdSocketAddress(String hostName, int port) {
        if (hostName == null) {
            throw new IllegalArgumentException("HostName can not be null");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Port must be >= 0");
        }
        this.hostName = hostName;
        this.port = port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.hostName.length() == 0 ? "0.0.0.0" : this.hostName, this.port);
    }

    public String toString() {
        return this.hostName + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshdSocketAddress that = (SshdSocketAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return this.hostName.equals(that.hostName);
    }

    public int hashCode() {
        int result = this.hostName.hashCode();
        result = 31 * result + this.port;
        return result;
    }
}

